/* $Id: WorkflowEngineHandlerPO.java,v 1.7 2005/08/26 04:53:54 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.RemoteException;

import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;

/**
 * WorkflowEngineHandlerPÓA[JWorkflowEngineHandlerɑ΂
 * [gĂяo̎NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler
 */
public class WorkflowEngineHandlerPO
extends PortableRemoteObject
implements WorkflowEngineHandlerRemote
{
	private WorkflowEngineHandler engineHandler;

	/**
	 * WorkflowEngineHandlerPO𐶐B
	 *
	 * @param handler GWnh
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	WorkflowEngineHandlerPO(WorkflowEngineHandler handler)
	throws RemoteException
	{
		this.engineHandler = handler;
	}

	/**
	 * vZXCX^X̐sB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param name vZXCX^X
	 * @return vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#createProcess(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String createProcess(String session, String pdid, String name)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		RemoteException
	{
		return engineHandler.createProcess(session, pdid, name);
	}

	/**
	 * vZXCX^X̊JnsB
	 * JnꍇɁAvZXCX^XIDXV悤
	 * \łB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @return XVꂽvZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#startProcess(java.lang.String, java.lang.String)
	 */
	public String startProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidAttributeException, RemoteException
	{
		return engineHandler.startProcess(session, pid);
	}

	/**
	 * vZXCX^X̒~sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#terminateProcess(java.lang.String, java.lang.String)
	 */
	public void terminateProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		RemoteException
	{
		engineHandler.terminateProcess(session, pid);
	}

	/**
	 * w肳ꂽvZXCX^Xp\ȏԈꗗ̎擾sB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return vZXCX^XԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getProcessStates(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public ProcessState[] getProcessStates(String session, 
			String pid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidFilterException, RemoteException
	{	
		return engineHandler.getProcessStates(session, pid, filter);
	}


	/**
	 * vZXCX^XԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#changeProcessState(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.ProcessState)
	 */
	public void changeProcessState(String session,
			String pid, ProcessState state)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidStateException, TransitionNotAllowedException, RemoteException
	{
		engineHandler.changeProcessState(session, pid, state);
	}

	/**
	 * vZXCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return ꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getProcessAttributes(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public Attribute[] getProcessAttributes(String session,
			String pid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidFilterException, RemoteException
	{		
		return engineHandler.getProcessAttributes(session, pid, filter);
	}

	/**
	 * vZXCX^X̑l̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getProcessAttributeValue(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Attribute getProcessAttributeValue(String session,
			String pid, String name)
	throws InvalidSessionException, InvalidAttributeException,
		RemoteException
	{
		return engineHandler.getProcessAttributeValue(session, pid, name);
	}

	/**
	 * vZXCX^X̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#assignProcessAttribute(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Attribute)
	 */
	public void assignProcessAttribute(String session,
			String pid, Attribute attr)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidAttributeException, AttributeAssignmentFailedException,
		RemoteException
	{
		engineHandler.assignProcessAttribute(session, pid, attr);
	}

	/**
	 * w肳ꂽANeBreBCX^Xp\ȏԈꗗ̎擾sB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^XԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getActivityStates(java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public ActivityState[] getActivityStates(String session,
			String pid, String aid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidFilterException,
		RemoteException
	{
		return engineHandler.getActivityStates(session, pid, aid, filter);
	}

	/**
	 * ANeBreBCX^XԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param state ANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#changeActivityState(java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.ActivityState)
	 */
	public void changeActivityState(String session,
			String pid, String aid, ActivityState state)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidStateException,
		TransitionNotAllowedException, RemoteException
	{
		engineHandler.changeActivityState(session, pid, aid, state);
	}

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getActivityAttributes(java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public Attribute[] getActivityAttributes(String session,
			String pid, String aid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidFilterException,
		RemoteException
	{
		return engineHandler.getActivityAttributes(session, pid, aid, filter);
	}

	/**
	 * ANeBreBCX^X̑l̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getActivityAttributeValue(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public Attribute getActivityAttributeValue(String session,
			String pid, String aid, String name)
	throws InvalidSessionException, InvalidAttributeException,
		RemoteException
	{
		return engineHandler.getActivityAttributeValue(session, pid, aid, name);
	}

	/**
	 * ANeBreBCX^X̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#assignActivityAttribute(java.lang.String, java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Attribute)
	 */
	public void assignActivityAttribute(String session,
			String pid, String aid, Attribute attr)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidAttributeException,
		AttributeAssignmentFailedException, RemoteException
	{
		engineHandler.assignActivityAttribute(session, pid, aid, attr);
	}

	/**
	 * vZXCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, StateFilterAGroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return vZẌꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getProcesses(java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public Process[] getProcesses(String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException, RemoteException
	{
		return engineHandler.getProcesses(session, filter);
	}

	/**
	 * vZXCX^X̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @return vZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getProcess(java.lang.String, java.lang.String)
	 */
	public Process getProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		RemoteException
	{
		Process proc = engineHandler.getProcess(session, pid);
		return proc;
	}

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter, StateFilterAGroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getActivities(java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public Activity[] getActivities(String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException, RemoteException
	{
		return engineHandler.getActivities(session, filter);
	}

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter, StateFilterAGroupFilterƂB
	 * WfMCdlłpid͂ȂA͌ł낤ƔfA
	 * pidɒǉB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getActivities(java.lang.String, java.lang.String, jp.co.argo21.nautica.workflow.wfmc.Filter)
	 */
	public Activity[] getActivities(String session, String pid, Filter filter)
	throws InvalidSessionException, InvalidFilterException, RemoteException
	{
		return engineHandler.getActivities(session, pid, filter);
	}

	/**
	 * ANeBreBCX^X̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @return ANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowEngineHandlerRemote#getActivity(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Activity getActivity(String session, String pid, String aid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, RemoteException
	{
		return engineHandler.getActivity(session, pid, aid);
	}
}
