/* $Id: WorkflowEngineHandlerRemote.java,v 1.5 2005/08/26 04:53:58 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;

/**
 * [Nt[GWnh́A[Nt[GWɑ΂
 * NCAgC^tF[XłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public interface WorkflowEngineHandlerRemote extends Remote {

	/**
	 * vZXCX^X̐sB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param name vZXCX^X
	 * @return vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public String createProcess(String session, String pdid, String name)
	throws InvalidSessionException, InvalidProcessDefinitionException, RemoteException;

	/**
	 * vZXCX^X̊JnsB
	 * JnꍇɁAvZXCX^XIDXV悤
	 * \łB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @return XVꂽvZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public String startProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidAttributeException, RemoteException;

	/**
	 * vZXCX^X̒~sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void terminateProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException, RemoteException;

	/**
	 * w肳ꂽvZXCX^Xp\ȏԈꗗ̎擾sB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return vZXCX^XԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public ProcessState[] getProcessStates(String session, 
			String pid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidFilterException, RemoteException;


	/**
	 * vZXCX^XԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void changeProcessState(String session,
			String pid, ProcessState state)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidStateException, TransitionNotAllowedException, RemoteException;

	/**
	 * vZXCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return ꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Attribute[] getProcessAttributes(String session,
			String pid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidFilterException, RemoteException;

	/**
	 * vZXCX^X̑l̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Attribute getProcessAttributeValue(String session,
			String pid, String name)
	throws InvalidSessionException, InvalidAttributeException, RemoteException;

	/**
	 * vZXCX^X̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void assignProcessAttribute(String session,
			String pid, Attribute attr)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidAttributeException, AttributeAssignmentFailedException, RemoteException;

	/**
	 * w肳ꂽANeBreBCX^Xp\ȏԈꗗ̎擾sB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^XԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public ActivityState[] getActivityStates(String session,
			String pid, String aid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidFilterException, RemoteException;

	/**
	 * ANeBreBCX^XԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param state ANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void changeActivityState(String session,
			String pid, String aid, ActivityState state)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidStateException,
		TransitionNotAllowedException, RemoteException;

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Attribute[] getActivityAttributes(String session,
			String pid, String aid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidFilterException, RemoteException;

	/**
	 * ANeBreBCX^X̑l̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Attribute getActivityAttributeValue(String session,
			String pid, String aid, String name)
	throws InvalidSessionException, InvalidAttributeException, RemoteException;

	/**
	 * ANeBreBCX^X̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void assignActivityAttribute(String session,
			String pid, String aid, Attribute attr)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidAttributeException,
		AttributeAssignmentFailedException, RemoteException;

	/**
	 * vZXCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, StateFilterAGroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return vZẌꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Process[] getProcesses(String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException, RemoteException;

	/**
	 * vZXCX^X̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @return vZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Process getProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException, RemoteException;

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter, StateFilterAGroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Activity[] getActivities(String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException, RemoteException;

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter, StateFilterAGroupFilterƂB
	 * WfMCdlłpid͂ȂA͌ł낤ƔfA
	 * pidɒǉB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Activity[] getActivities(String session, String pid, Filter filter)
	throws InvalidSessionException, InvalidFilterException, RemoteException;

	/**
	 * ANeBreBCX^X̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @return ANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public Activity getActivity(String session, String pid, String aid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, RemoteException;
}
