/* $Id: WorkflowServiceManagerPO.java,v 1.3 2005/08/26 04:53:50 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.RemoteException;

import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;

/**
 * WorkflowServiceManagerPÓA[JWorkflowServiceManagerɑ΂
 * [gĂяo̎NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 * @see jp.co.argo21.nautica.workflow.wfmc.WorkflowServiceManager
 */
public class WorkflowServiceManagerPO
extends PortableRemoteObject
implements WorkflowServiceManagerRemote
{
	private WorkflowEngine engine;

	private DefinitionRepositoryRemote definitionRepository;
	private WorkflowEngineHandlerRemote workflowEngineHandler;
	private WorkflowAdminHandlerRemote workflowAdminHandler;
	private WorkItemHandlerRemote workItemHandler;
	
	/**
	 * WorkflowServiceManagerPO𐶐B
	 *
	 * @param engine [Nt[GW
	 * @param repository `|Wg
	 * @param engineHandler GWnh
	 * @param adminHandler Ǘnh
	 * @param itemHandler ƍڃnh
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public WorkflowServiceManagerPO(
			WorkflowEngine engine,
			DefinitionRepository repository,
			WorkflowEngineHandler engineHandler,
			WorkflowAdminHandler adminHandler,
			WorkItemHandler itemHandler
			)
	throws RemoteException
	{
		this.engine = engine;
		
		definitionRepository = new DefinitionRepositoryPO(repository);
		workflowEngineHandler = new WorkflowEngineHandlerPO(engineHandler);
		workflowAdminHandler = new WorkflowAdminHandlerPO(adminHandler);
		workItemHandler = new WorkItemHandlerPO(itemHandler);
	}

	/**
	 * [Nt[GWւ̐ڑF؂sA
	 * ZbVID擾B
	 *
	 * @param user [UID
	 * @param pass pX[h
	 * @return ZbVID
	 * @throws ConnectionFailedException ڑF؂Ɏsꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerRemote#connect(java.lang.String, java.lang.String)
	 */
	public String connect(String user, String pass)
	throws ConnectionFailedException, RemoteException
	{
		return engine.connect(user, pass);
	}

	/**
	 * [Nt[GWƂ̐ؒfsB
	 *
	 * @param session ZbVID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerRemote#disconnect(java.lang.String)
	 */
	public void disconnect(String session)
	throws InvalidSessionException, RemoteException
	{
		engine.disconnect(session);
	}

	/**
	 * `|WgԂB
	 *
	 * @param session ZbVID
	 * @return `|Wg
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerRemote#getDefinitionRepository(java.lang.String)
	 */
	public DefinitionRepositoryRemote getDefinitionRepository(String session)
	throws InvalidSessionException, RemoteException
	{
		return definitionRepository;
	}

	/**
	 * ƍڃnhԂB
	 *
	 * @param session ZbVID
	 * @return ƍڃnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerRemote#getWorkItemHandler(java.lang.String)
	 */
	public WorkItemHandlerRemote getWorkItemHandler(String session)
	throws InvalidSessionException, RemoteException
	{
		return workItemHandler;
	}

	/**
	 * [Nt[GWnhԂB
	 *
	 * @param session ZbVID
	 * @return [Nt[GWnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerRemote#getWorkflowEngineHandler(java.lang.String)
	 */
	public WorkflowEngineHandlerRemote getWorkflowEngineHandler(String session)
	throws InvalidSessionException, RemoteException
	{
		return workflowEngineHandler;
	}

	/**
	 * [Nt[ǗnhԂB
	 *
	 * @param session ZbVID
	 * @return [Nt[Ǘnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerRemote#getWorkflowAdminHandler(java.lang.String)
	 */
	public WorkflowAdminHandlerRemote getWorkflowAdminHandler(String session)
	throws InvalidSessionException, RemoteException
	{
		return workflowAdminHandler;
	}
}
