/* $Id: WorkflowServiceManagerRemote.java,v 1.3 2005/08/26 04:53:53 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

/**
 * [Nt[T[rX}l[́A[Nt[GWɑ΂
 * NCAgC^tF[XłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public interface WorkflowServiceManagerRemote extends Remote {

	/**
	 * [Nt[GWւ̐ڑF؂sA
	 * ZbVID擾B
	 *
	 * @param user [UID
	 * @param pass pX[h
	 * @return ZbVID
	 * @throws ConnectionFailedException ڑF؂Ɏsꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public String connect(String user, String pass)
	throws ConnectionFailedException, RemoteException;

	/**
	 * [Nt[GWƂ̐ؒfsB
	 *
	 * @param session ZbVID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public void disconnect(String session)
	throws InvalidSessionException, RemoteException;

	/**
	 * `|WgԂB
	 *
	 * @param session ZbVID
	 * @return `|Wg
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public DefinitionRepositoryRemote getDefinitionRepository(String session)
	throws InvalidSessionException, RemoteException;

	/**
	 * ƍڃnhԂB
	 *
	 * @param session ZbVID
	 * @return ƍڃnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public WorkItemHandlerRemote getWorkItemHandler(String session)
	throws InvalidSessionException, RemoteException;

	/**
	 * [Nt[GWnhԂB
	 *
	 * @param session ZbVID
	 * @return [Nt[GWnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public WorkflowEngineHandlerRemote getWorkflowEngineHandler(String session)
	throws InvalidSessionException, RemoteException;

	/**
	 * [Nt[ǗnhԂB
	 *
	 * @param session ZbVID
	 * @return [Nt[Ǘnh
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws RemoteException ʐMQȂǂ̏ꍇ
	 */
	public WorkflowAdminHandlerRemote getWorkflowAdminHandler(String session)
	throws InvalidSessionException, RemoteException;
}
