/* $Id: RoleManager.java,v 1.6 2005/08/26 04:55:46 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security;

import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

/**
 * {[Nt[VXe^p՗pC^tF[XK肷B
 * RoleManageŕAǗ֘ÅeAPI`B
 * ۂɂ́ACӂ̌ǗVXe𗘗p邽߂ɁA
 * ̃C^tF[X𗘗p̎pӂȂ΂ȂȂB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public interface RoleManager {

	/**
	 * ridɑΉ錠ԂB
	 * ridɑΉ錠Ȃꍇ null ԂB
	 *
	 * @param rid ID
	 * @return 
	 * @throws InvalidRoleException w肳ꂽLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Role getRole(String rid)
	throws InvalidRoleException, WorkflowSecurityException;

	/**
	 * gDɕt^ĂSԂB
	 * ݂Ȃꍇ͋̔zԂB
	 *
	 * @param org gDP
	 * @return ̈ꗗ
	 * @throws InvalidOrganizationException
	 * @throws WorkflowSecurityException
	 * @throws InvalidRoleException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Role[] getAttachedRoles(Organization org)
	throws InvalidOrganizationException, WorkflowSecurityException;

	/**
	 * [Uɕt^ĂSԂB
	 * ݂Ȃꍇ͋̔zԂB
	 *
	 * @param user [U
	 * @return ̈ꗗ
	 * @throws InvalidRoleException w肳ꂽ[ULłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Role[] getAttachedRoles(User user)
	throws InvalidUserException, WorkflowSecurityException;

	/**
	 * SgDPʂԂB
	 * gD݂Ȃꍇ͋̔zԂB
	 *
	 * @param role 
	 * @return gDPʂ̈ꗗ
	 * @throws InvalidRoleException w肳ꂽLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Organization[] getOrganizationsByRole(Role role)
	throws InvalidRoleException, WorkflowSecurityException;

	/**
	 * S[UԂB
	 * [U݂Ȃꍇ͋̔zԂB
	 *
	 * @param role 
	 * @return [Üꗗ
	 * @throws InvalidRoleException w肳ꂽLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public User[] getUsersByRole(Role role)
	throws InvalidRoleException, WorkflowSecurityException;
}
