/* $Id: SessionManager.java,v 1.5 2005/08/26 04:55:47 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security;

import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

/**
 * ZbVǗsB
 * ۂɂ́ACӂ̃ZbVǗVXe𗘗p邽߂ɁA
 * ̃C^tF[X𗘗p̎pӂȂ΂ȂȂB
 * {[Nt[VXe^pՂł́A
 * QlƂSimpleSessionManager񋟂B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public interface SessionManager
{
	/**
	 * ̃[UIDƃpX[hpāAF؂sB
	 * ߂lƂāAΉtZbVIDԂB
	 *
	 * @param uid [UID
	 * @param password pX[h
	 * @return ZbVID
	 * @throws ConnectionFailedException ڑF؂Ɏsꍇ
	 */
	public String createSession(String uid, String password)
	throws ConnectionFailedException;

	/**
	 * ƂēnꂽZbVID؂B
	 * ZbVIDɑΉZbV񂪂΁A
	 * ŏIANZXԂXVB
	 * ߂lƂāAΉtZbVIDԂB
	 * ΉZbV񂪂Ȃ΁AOԂB
	 * ŐVKɃ[蓖Ă邱Ƃ͂ȂB
	 * ZbVIDLłȂꍇ́AOƂB
	 *
	 * @param session ZbVID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public void validateSession(String session)
	throws InvalidSessionException;
	
	/**
	 * ɓnꂽZbVIDƁAɑΉZbV𖳌ɂB
	 * ZbVIDLłȂꍇ́AOƂB
	 *
	 * @param session ZbVID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public void invalidateSession(String session)
	throws InvalidSessionException;
	
	/**
	 * ɓnꂽZbVIDɌѕtĂAUserIuWFNgԂB
	 *
	 * @param session ZbVID
	 * @return ZbVIDɌѕtĂUser
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 */
	public User getSessionUser(String session)
	throws InvalidSessionException;
}
