/* $Id: OrganizationManager.java,v 1.6 2005/08/26 04:55:28 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.security.InvalidOrganizationException;
import jp.co.argo21.nautica.workflow.security.InvalidUserException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

/**
 * OrganizationManageŕAgDǗ֘ÅeAPI`B
 * ۂɂ́ACӂ̑gDǗVXe𗘗p邽߂ɁA
 * ̃C^tF[X𗘗p̎pӂȂ΂ȂȂB
 * ̃C^tF[X́AGWOĂяo郁\bh
 * ǉꂽꍇɁAGWŎg API ƕ邽
 * ɒ`̂łB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public interface OrganizationManager extends
		jp.co.argo21.nautica.workflow.security.OrganizationManager {
	/**
	 * oidɑΉgDԂB
	 * oidɑΉgD݂Ȃꍇ null ԂB
	 *
	 * @param oid gDID
	 * @return gDP
	 * @throws InvalidOrganizationException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Organization getOrganization(String oid)
	throws InvalidOrganizationException, WorkflowSecurityException;

	/**
	 * [UɑĂ郆[ÜꗗԂB
	 * [U݂Ȃꍇ͋̔zԂB
	 *
	 * @param org gDP
	 * @return [Uꗗ
	 * @throws InvalidOrganizationException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public User[] getAssignedUser(Organization org)
	throws InvalidOrganizationException, WorkflowSecurityException;

	/**
	 * [ȔgDԂB
	 * gD݂Ȃꍇ͋̔zԂB
	 * 
	 * @param user [U
	 * @return gDꗗ
	 * @throws InvalidUserException w肳ꂽ[ULłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException RemoteException 
	 */
	public Organization[] getOrganizationByUser(User user)
	throws InvalidUserException, WorkflowSecurityException;
	
	/**
	 * YgD̏ʑgDԂB
	 * ʑgD݂Ȃꍇ null ԂB
	 *
	 * @param org gDP
	 * @return ʑgD
	 * @throws InvalidOrganizationException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Organization getHigherOrganization(Organization org)
	throws InvalidOrganizationException, WorkflowSecurityException;
}
