/* $Id: OrganizationManagerPO.java,v 1.7 2005/08/26 04:55:28 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.rmi.RemoteException;

import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.workflow.security.InvalidOrganizationException;
import jp.co.argo21.nautica.workflow.security.InvalidUserException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

/**
 * OrganizationManagerPO ́A[J OrganizationManager ɑ΂
 * [gĂяo̎NXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class OrganizationManagerPO 
	extends PortableRemoteObject implements OrganizationManagerRemote {

	private OrganizationManager om;
	
	/**
	 * OrganizationManagerPO 𐶐B
	 * oidɑΉgD݂Ȃꍇ null ԂB
	 * 
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 */
	public OrganizationManagerPO(OrganizationManager om) 
	throws RemoteException {
		super();
		this.om = om;
	}

	/**
	 * oidɑΉgDԂB
	 * [U݂Ȃꍇ͋̔zԂB
	 *
	 * @param oid gDID
	 * @return gDP
	 * @throws InvalidOrganizationException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.security.simple.OrganizationManagerRemote#getOrganization(java.lang.String)
	 */
	public Organization getOrganization(String oid)
	throws InvalidOrganizationException, WorkflowSecurityException,
			RemoteException {
		return om.getOrganization(oid);
	}

	/**
	 * YgDɑĂ郆[ÜꗗԂB
	 * [U݂Ȃꍇ͋̔zԂB
	 *
	 * @param org gDP
	 * @return [Uꗗ
	 * @throws InvalidOrganizationException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.security.simple.OrganizationManagerRemote#getAssignedUser(jp.co.argo21.nautica.workflow.security.Organization)
	 */
	public User[] getAssignedUser(Organization org)
	throws InvalidOrganizationException, WorkflowSecurityException,
			RemoteException {
		return om.getAssignedUser(org);
	}

	/**
	 * Y[ȔgDԂB
	 * gD݂Ȃꍇ͋̔zԂB
	 * 
	 * @param user [U
	 * @return gDꗗ
	 * @throws InvalidUserException w肳ꂽ[ULłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.security.simple.OrganizationManagerRemote#getOrganizationByUser(jp.co.argo21.nautica.workflow.security.User)
	 */
	public Organization[] getOrganizationByUser(User user)
	throws InvalidUserException, WorkflowSecurityException,
			RemoteException {
		return om.getOrganizationByUser(user);
	}
	
	/**
	 * YgD̏ʑgDԂB
	 * ʑgD݂Ȃꍇ null ԂB
	 *
	 * @param org gDP
	 * @return ʑgD
	 * @throws InvalidOrganizationException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException ʐMQ̗O
	 */
	public Organization getHigherOrganization(Organization org)
	throws InvalidOrganizationException, WorkflowSecurityException, 
			RemoteException {
		return om.getHigherOrganization(org);
	}

}
