/* $Id: RoleManagerPO.java,v 1.5 2005/08/26 04:55:29 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.rmi.RemoteException;

import javax.rmi.PortableRemoteObject;

import jp.co.argo21.nautica.workflow.security.InvalidOrganizationException;
import jp.co.argo21.nautica.workflow.security.InvalidRoleException;
import jp.co.argo21.nautica.workflow.security.InvalidUserException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

/**
 * RoleManagerPO ́A[J RoleManagerRemote ɑ΂
 * [gĂяo̎NXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class RoleManagerPO 
	extends PortableRemoteObject implements RoleManagerRemote {

	private RoleManager rm; 
	
	/**
	 * RoleManagerPO 𐶐B
	 * 
	 * 
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 */
	public RoleManagerPO(RoleManager rm) 
	throws RemoteException {
		super();
		this.rm = rm;
	}

	/**
	 * ridɑΉ錠ԂB
	 * ridɑΉ錠Ȃꍇ null ԂB
	 *
	 * @param rid ID
	 * @return 
	 * @throws InvalidRoleException w肳ꂽLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote#getRole(java.lang.String)
	 */
	public Role getRole(String rid) throws InvalidRoleException,
	WorkflowSecurityException, RemoteException {
		return rm.getRole(rid);
	}

	/**
	 * gDɕt^ĂSԂB
	 * ݂Ȃꍇ͋̔zԂB
	 *
	 * @param org gDP
	 * @return ̈ꗗ
	 * @throws InvalidOrganizationException
	 * @throws WorkflowSecurityException
	 * @throws InvalidRoleException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote#getAttachedRoles(jp.co.argo21.nautica.workflow.security.Organization)
	 */
	public Role[] getAttachedRoles(Organization org)
	throws InvalidOrganizationException, WorkflowSecurityException,
			RemoteException {
		return rm.getAttachedRoles(org);
	}

	/**
	 * [Uɕt^ĂSԂB
	 * ݂Ȃꍇ͋̔zԂB
	 *
	 * @param user [U
	 * @return ̈ꗗ
	 * @throws InvalidRoleException w肳ꂽ[ULłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote#getAttachedRoles(jp.co.argo21.nautica.workflow.security.User)
	 */
	public Role[] getAttachedRoles(User user) throws InvalidUserException,
	WorkflowSecurityException, RemoteException {
		return rm.getAttachedRoles(user);
	}

	/**
	 * SgDPʂԂB
	 * gD݂Ȃꍇ͋̔zԂB
	 *
	 * @param role 
	 * @return gDPʂ̈ꗗ
	 * @throws InvalidRoleException w肳ꂽLłȂꍇ
	 * @throws RemoteException  ʐMQȂǂ̏ꍇ
	 * @see jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote#getOrganizationsByRole(jp.co.argo21.nautica.workflow.security.Role)
	 */
	public Organization[] getOrganizationsByRole(Role role)
	throws InvalidRoleException, WorkflowSecurityException,
			RemoteException {
		return rm.getOrganizationsByRole(role);
	}

	/**
	 * S[UIDԂB
	 * [U݂Ȃꍇ͋̔zԂB
	 *
	 * @param role 
	 * @return [Üꗗ
	 * @throws InvalidRoleException w肳ꂽLłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException RemoteException 
	 * @see jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote#getUsersByRole(jp.co.argo21.nautica.workflow.security.Role)
	 */
	public User[] getUsersByRole(Role role) throws InvalidRoleException,
	WorkflowSecurityException, RemoteException {
		return rm.getUsersByRole(role);
	}

}
