/* $Id: SimpleOrganizationManager.java,v 1.15 2005/08/26 04:55:35 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import javax.naming.Context;
import javax.naming.InitialContext;

import jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.security.InvalidOrganizationException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

import org.apache.log4j.Logger;

/**
 * {[Nt[VXe^pՂъO痘pgDǗ֘ÅeAPI
 * 񋟂QlłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.15 $
 * @since   Nautica Workflow 0.9
 */
public class SimpleOrganizationManager implements OrganizationManager {

	private static final String WORKFLOW_ORGANIZATION_MANAGER 
		= "WorkflowOrganizationManager";

	private static Logger sLog = LogManager.getSercurityLogger(); 
	
	/**
	 * SimpleOrganizationManager 𐶐B
	 * 
	 * @throws Exception gDǗ̌JɎsꍇ
	 */
	public SimpleOrganizationManager() throws Exception {
		try {
			OrganizationManagerPO omPO 
				= new OrganizationManagerPO(this);
			Context context = new InitialContext();
			context.rebind(WORKFLOW_ORGANIZATION_MANAGER, omPO);
			sLog.info(StringManager.get("I1006"));
		
		} catch (Exception ex) {
			// gDǗ̌JɎs܂B
			String errMsg = StringManager.get("E1007");
			sLog.error(errMsg, ex);
			throw ex;
		}
	}
	
	/**
	 * oidɑΉgDԂB
	 * oidɑΉgD݂Ȃꍇ null ԂB
	 *
	 * @param  oid gDID
	 * @return gDP
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @see jp.co.argo21.nautica.workflow.security.OrganizationManager#getOrganization(java.lang.String)
	 */
	public Organization getOrganization(String oid)
	throws WorkflowSecurityException {
		
	    try {	        
	        OrganizationManagerDAO orgmanagerDAO = getOrganizationManagerDAO();
	        Organization org = orgmanagerDAO.findByOrganizationID(oid);
	        
	        return org;
	        
	    } catch (Exception e) {
	        // gD̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1018") + "(OrganizationID = " + oid + ")";
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg , e);
	    }
	}

	/**
	 * gDɑĂ郆[ÜꗗԂB
	 * w肳ꂽgDɑ郆[U݂ȂꍇA
	 * w肳ꂽgD݂Ȃꍇ́A̔zԂB
	 *
	 * @param  org gDP
	 * @return [Uꗗ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @see jp.co.argo21.nautica.workflow.security.OrganizationManager#getAssignedUser(jp.co.argo21.nautica.workflow.security.Organization)
	 */
	public User[] getAssignedUser(Organization org)
	throws WorkflowSecurityException {
		
	    try {
	        OrganizationManagerDAO orgmanagerDAO = getOrganizationManagerDAO();
	        User[] users = orgmanagerDAO.findUsersByOrganizationID(org.getID());
	        
	        return users;
	        
	    } catch (Exception e) {
	        // [U̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1019");
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg, e);
	    }
	}

	/**
	 * [ȔgDԂB
	 * w肳ꂽ[ȔgD݂ȂꍇA
	 * w肳ꂽ[U݂Ȃꍇ́A̔zԂB
	 * 
	 * @param  user [U
	 * @return gDꗗ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @see jp.co.argo21.nautica.workflow.security.OrganizationManager#getOrganizationByUser(jp.co.argo21.nautica.workflow.security.User)
	 */
	public Organization[] getOrganizationByUser(User user)
	throws WorkflowSecurityException {
		
	    try {
	        OrganizationManagerDAO orgmanagerDAO = getOrganizationManagerDAO();
	        Organization[] orgs = orgmanagerDAO.findByUserID(user.getID());
	        
	        return orgs;
	        
	    } catch (Exception e) {
	        // gD̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1020");
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg, e);
	    }
	}
	
	/**
	 * YgD̏ʑgDԂB
	 * ʑgD݂Ȃꍇ null ԂB
	 *
	 * @param  org gDP
	 * @return ʑgD
	 * @throws InvalidOrganizationException w肳ꂽgDLłȂꍇ
	 * @throws WorkflowSecurityException    ̑̃ZLeBO
	 * @see jp.co.argo21.nautica.workflow.security.simple.OrganizationManager#getHigherOrganization(jp.co.argo21.nautica.workflow.security.Organization)
	 */
	public Organization getHigherOrganization(Organization org)
	throws InvalidOrganizationException, WorkflowSecurityException {
	    try {
	        OrganizationManagerDAO orgmanagerDAO = getOrganizationManagerDAO();
	        Organization higher = orgmanagerDAO.findHigherByOrganizationID(org.getID());
	        
	        return higher;
	        
	    } catch (Exception e) {
	        // ʑgD̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1021");
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg, e);
	    }
	}
	
	/**
	 * OrganizationManagerDAOIuWFNgԂB
	 * 
	 * @return OrganizationManagerDAOIuWFNg
	 * @throws Exception f[^x[XANZXG[ꍇ
	 */
	private OrganizationManagerDAO getOrganizationManagerDAO() throws Exception {
	    WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
	    return daoFactory.getOrganizationManagerDAO();
	}
}
