/* $Id: SimpleRoleManager.java,v 1.15 2005/08/26 04:55:30 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import javax.naming.Context;
import javax.naming.InitialContext;

import jp.co.argo21.nautica.workflow.dataaccess.RoleManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

import org.apache.log4j.Logger;

/**
 * {[Nt[VXe^pՂъO痘p錠Ǘ֘ÅeAPI
 * 񋟂QlłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.15 $
 * @since   Nautica Workflow 0.9
 */
public class SimpleRoleManager implements RoleManager {

	private static final String WORKFLOW_ROLE_MANAGER 
		= "WorkflowRoleManager";

	private static Logger sLog = LogManager.getSercurityLogger();
	
	/**
	 * SimpleRoleManager 𐶐B
	 * 
	 * @throws Exception gDǗ̌JɎsꍇ
	 */
	public SimpleRoleManager() throws Exception {
		try {
			RoleManagerPO rmPO 
				= new RoleManagerPO(this);
			Context context = new InitialContext();
			context.rebind(WORKFLOW_ROLE_MANAGER, rmPO);
			sLog.info(StringManager.get("I1007"));
		
		} catch (Exception ex) {
			// Ǘ̌JɎs܂B
			String errMsg = StringManager.get("E1009");
			sLog.error(errMsg, ex);
			throw ex;
		
		}
	}
	
	/**
	 * ridɑΉ錠ԂB
	 * ridɑΉ錠Ȃꍇ null ԂB
	 *
	 * @param  rid ID
	 * @return 
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Role getRole(String rid)
	throws WorkflowSecurityException {
	   
	    try {
	        RoleManagerDAO rolemanagerDAO = getRoleManagerDAO();	        
	        Role role = rolemanagerDAO.findByRoleID(rid);
	        
	        return role;
	    
	    } catch (Exception e) {
	        // ̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1022") + "(RoleID = " + rid + ")";
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg, e);
	    }
	}

	/**
	 * gDɕt^ĂSԂB
	 * w肳ꂽgDɕt^Ă錠݂ȂꍇA
	 * w肳ꂽgD݂Ȃꍇ́A̔zԂB
	 *
	 * @param  org gDP
	 * @return ̈ꗗ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Role[] getAttachedRoles(Organization org)
	throws WorkflowSecurityException {
		
	    try {	        
	        RoleManagerDAO rolemanagerDAO = getRoleManagerDAO();
	        Role[] roles = rolemanagerDAO.findByOrganizationID(org.getID());
	        
	        return roles;
	    
	    } catch (Exception e) {
	        // 蓖Č̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1023");
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg, e);
	    }
	}

	/**
	 * [Uɕt^ĂSԂB
	 * w肳ꂽ[Uɕt^Ă錠݂ȂꍇA
	 * w肳ꂽ[U݂Ȃꍇ́A̔zԂB
	 *
	 * @param  user [U
	 * @return ̈ꗗ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Role[] getAttachedRoles(User user)
	throws WorkflowSecurityException {
		
	    try {	        
	        RoleManagerDAO rolemanagerDAO = getRoleManagerDAO();
	        Role[] roles = rolemanagerDAO.findByUserID(user.getID());
	        
	        return roles;
	        	        
	    } catch (Exception e) {
	        // 蓖Č̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1023");
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg, e);
	    }
	}

	/**
	 * SgDPʂԂB
	 * w肳ꂽgD݂ȂꍇA
	 * w肳ꂽ݂Ȃꍇ́A̔zԂB
	 *
	 * @param  role 
	 * @return gDPʂ̈ꗗ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public Organization[] getOrganizationsByRole(Role role)
	throws WorkflowSecurityException {

	    try {
	        RoleManagerDAO rolemanagerDAO = getRoleManagerDAO();
	        Organization[] orgs = rolemanagerDAO.findOrganizationsByRoleID(role.getID());
	        
	        return orgs;
	        
	    } catch (Exception e) {
	        // gD̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1020");
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg, e);
	    }
	}

	/**
	 * S[UԂB
	 * w肳ꂽ[U݂ȂꍇA
	 * w肳ꂽ݂Ȃꍇ́A̔zԂB
	 *
	 * @param  role 
	 * @return [Üꗗ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public User[] getUsersByRole(Role role)
	throws WorkflowSecurityException {
		
	    try {	        
	        RoleManagerDAO rolemanagerDAO = getRoleManagerDAO();
	        User[] users = rolemanagerDAO.findUsersByRoleID(role.getID());
	        
	        return users;
	        
	    } catch (Exception e) {
	        // [U̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1019");
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg, e);
	    }
	}
	
	/**
	 * RoleManagerDAOIuWFNgԂB
	 * 
	 * @return RoleManegerDAOIuWFNg
	 * @throws Exception f[^x[XANZXG[ꍇ
	 */
	private RoleManagerDAO getRoleManagerDAO() throws Exception {
	    WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        return daoFactory.getRoleManagerDAO();
	}
}