/* $Id: SimpleSession.java,v 1.4 2005/08/26 04:55:26 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.security.SecureRandom;
import java.util.Date;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Session;
import jp.co.argo21.nautica.workflow.security.User;

/**
 * SimpleSessiońASimpleSessionManagerp̃ZbV\NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class SimpleSession implements Session {

    /** ZbVID */
    private String sid;
    
    /** [U */
    private User user;
    
    /** ZbV */
    private Date createdTime;
    
    /** ŏIANZX */
    private Date lastAccessedTime;
    
    /**
     * ZbV̏ݒsB
     * ZbVIDA[Uݒ肵A
     * ݎZbVԂэŏIANZXԂƂB
     * 
     * @param user [U
     */
    SimpleSession(User user) {
        this.sid = SecureIDGenerator.createID(this);
        this.user = user;
        
		Date nowTime = new Date();
		createdTime = nowTime;
		lastAccessedTime = nowTime;
    }
    
	/**
	 * ZbVID
	 *
	 * @return ZbVID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Session#getID()
	 */
	public String getID() throws WorkflowException{
		
	    updateLastAccessedTime();
		return sid;
	}
	
	/**
	 * ̃ZbVɊtꂽ[U
	 *
	 * @return [U
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Session#getUser()
	 */
	public User getUser() throws WorkflowException {
		
	    updateLastAccessedTime();
		return user;
	}

	/**
	 * ̃ZbV̐
	 *
	 * @return ZbV̐
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Session#getCreatedTime()
	 */
	public Date getCreatedTime() throws WorkflowException {
		
		return createdTime;
	}

	/**
	 * ̃ZbVւ̍Ō̃ANZX
	 *
	 * @return Ō̃ANZX
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 * @see jp.co.argo21.nautica.workflow.security.Session#getLastAccessedTime()
	 */
	public Date getLastAccessedTime() throws WorkflowException {
		
		return lastAccessedTime;
	}
	
	/**
	 * ŏIANZXԂXVB
	 */
	private void updateLastAccessedTime() {
	    
	    lastAccessedTime = new Date();
	}
}

/**
 * ZLA ID 𐶐NXłB
 *
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
class SecureIDGenerator {

    /**
     * '0'16̕
     * <code>long</code>16i\Ɏgp
     */
    private static final String ZERO16 = "0000000000000000";
    
    /**
     * '0'8̕
     * <code>int</code>16i\Ɏgp
     */
    private static final String ZERO8  = "00000000";
        
    /** WFl[^ */
  	private static SecureRandom seeder = new SecureRandom();
    
    /**
     * ZLA ID 𐶐B
     * 
     * @param   obj     ID t^ΏۃIuWFNg
     * @return  ZLA ID
     */
    public static synchronized String createID(Object obj) {
        /* @́ÃTCg 64p ` 65p QƂB */
        /* <http://www-6.ibm.com/jp/software/websphere/developer/j2ee/pdf/4_3.pdf> */

		// ݂̎擾
		long currentTime = System.currentTimeMillis();
		String currentTimeStr = toHexString(currentTime);

		// ID t^ΏۃIuWFNg̃nbVR[h擾
		String hashCodeStr = toHexString(System.identityHashCode(obj)); 

        // 𐶐
		String randomStr = toHexString(seeder.nextInt());
		
		// ZLA ID 𐶐
        String secureID = currentTimeStr + hashCodeStr + randomStr;

		return secureID;
    }
    
    /**
     * w肳ꂽ^16i\擾B
     * 
     * w肳ꂽ^16i\8oCgɖȂꍇA
     * s0tB
     * 
     * @param   num     
     * @return  16i\
     */
    private static String toHexString(int num)
    {
        String hexStr = Integer.toHexString(num);
        String zeroStr = ZERO8.substring(0, 8 - hexStr.length());
        
        return zeroStr + hexStr;
    }

    /**
     * w肳ꂽ^16i\擾B
     * 
     * w肳ꂽ^16i\16oCgɖȂꍇA
     * s0tB
     * 
     * @param   num     
     * @return  16i\
     */
    private static String toHexString(long num)
    {
        String hexStr = Long.toHexString(num);
        String zeroStr = ZERO16.substring(0, 16 - hexStr.length());
        
        return zeroStr + hexStr;
    }
}