/* $Id: SimpleSessionManager.java,v 1.15 2005/08/26 04:55:34 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Session;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

import org.apache.log4j.Logger;

/**
 * ZbVǗsQlNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.15 $
 * @since   Nautica Workflow 0.9
 */
public class SimpleSessionManager implements SessionManager
{
    /** pX[h擾邽߂̃[ŨL[l */
    private static final String PASSWORD = "PASSWORD";
        
    /** ZbV̗LԁF30i~bj */
    private static final long VALIDTERM = 1800000L;
    
    /** Oo͗pIuWFNg */
    private static Logger sLog = LogManager.getSercurityLogger();
	
    /** Ǘ̃ZbV̏W */
    private Map sessions = Collections.synchronizedMap(new HashMap());
        
    /**
     * SimpleSessionManager𐶐B
     * ̃RXgN^́ASessionManagerFactory
     * tNVɂČĂяoB
     */
    public SimpleSessionManager()
    {
        /* ^CAEgm̂߁A^C}𐶐A^XNXPW[OB
         * ^XN̎sԊúAZbVLԂ̔ƂB*/
        Timer timer = new Timer();
        timer.schedule(new TimeoutTimerTask(this), VALIDTERM, VALIDTERM / 2);
    }

    /**
     * ̃[UIDƃpX[hpāAF؂sB
     * ߂lƂāAΉtZbVIDԂB
     *
     * @param  uid      [UID
     * @param  password pX[h
     * @return ZbVID
     * @throws ConnectionFailedException ڑF؂Ɏsꍇ
     * @see jp.co.argo21.nautica.workflow.security.SessionManager#createSession(java.lang.String, java.lang.String)
     */
    public String createSession(String uid, String password)
    throws ConnectionFailedException
    {
        /* User擾 */
        User user = null;
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            UserManagerDAO usermanagerDAO = daoFactory.getUserManagerDAO();
            user = usermanagerDAO.findByUserID(uid);
        
        } catch (Exception e) {
            // [U擾Ɏs܂B
            String errMsg = StringManager.get("E1010") 
                + "(UserID=" + uid + ")";
            sLog.error(errMsg);
            throw new ConnectionFailedException(errMsg, e);
        } 

        /* Useȓ݃`FbN */
        if (user == null) {
            // [U܂B
            String errMsg = StringManager.get("E1011")
                + "(UserID=" + uid + ")";
            sLog.error(errMsg);
            throw new ConnectionFailedException(errMsg);
        }        
        
        /* pX[h擾Ar */
        String basepassword = "";
        try {
            basepassword = user.getAttribute(PASSWORD);
            
        } catch (WorkflowException e) {
            // pX[h擾Ɏs܂B
            String errMsg = StringManager.get("E1012")
                + "(UserID=" + uid + ")";
            sLog.error(errMsg);
            throw new ConnectionFailedException(errMsg, e);
        }

        if (!password.equals(basepassword)) {
            // [UF؂Ɏs܂B
            String errMsg = StringManager.get("E1013")
                + "(UserID=" + uid + ")";
            sLog.error(errMsg);
            throw new ConnectionFailedException(errMsg);
        }        
                
        /* ZbV쐬iID̔Ԃƃ[Ůtj*/
        Session session = new SimpleSession(user);
        String sid = "";
        try {
            sid = session.getID();
            
        } catch (WorkflowException e) {
            // ZbVID̎擾Ɏs܂B
            String errMsg = StringManager.get("E1014")
                + "(UserID=" + uid + ")";
            sLog.error(errMsg);
            throw new ConnectionFailedException(errMsg, e);            
        }
        
        /* ZbVǗɂ */
        sessions.put(sid, session);
        return sid;
    }

    /**
     * ƂēnꂽZbVID؂B
     * ZbVIDɑΉZbV񂪂΁A
     * ŏIANZXԂXVB
     * ΉZbV񂪂Ȃ΁AOԂB
     * ZbVIDLłȂꍇ́AOƂB
     *
     * @param  sid ZbVID
     * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
     * @see jp.co.argo21.nautica.workflow.security.SessionManager#validateSession(java.lang.String)
     */
    public void validateSession(String sid)
    throws InvalidSessionException
    {
        /* ZbV擾BȂΗO𓊂B*/
        Session session = (Session) sessions.get(sid);
        if (session == null) {
            // ȃZbVw肳܂B
            String errMsg = StringManager.get("E1015")
                + "(SessionID=" + sid + ")";
            sLog.error(errMsg);
            throw new InvalidSessionException(errMsg);
        }
        
        /* ŏIANZXԂXV */
        try {
            /* Session C^tF[XɁAupdateLastAccessedTime 
             * `ĂȂ߁AgetID() sB
             * getID() ́AōŏIANZXԂXVĂB */
            session.getID();
            
        } catch (WorkflowException e) {
            // ŏIANZXԂ̍XVɎs܂B
            String errMsg = StringManager.get("E1017")
                + "(SessionID=" + sid + ")";
            sLog.error(errMsg);
            throw new InvalidSessionException(errMsg, e);
        }
    }
    
    /**
     * ɓnꂽZbVIDƁAɑΉZbV𖳌ɂB
     * ZbVIDLłȂꍇ́AOƂB
     *
     * @param  sid ZbVID
     * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
     * @see jp.co.argo21.nautica.workflow.security.SessionManager#invalidateSession(java.lang.String)
     */
    public void invalidateSession(String sid)
    throws InvalidSessionException
    {
        /* ZbV擾BȂΗO𓊂B*/
        Session session = (Session) sessions.get(sid);
        if (session == null) {
            // ȃZbVw肳܂B
            String errMsg = StringManager.get("E1015")
                + "(SessionID=" + sid + ")";
            throw new InvalidSessionException(errMsg);
        }
        
        /* ZbVǗO */
        sessions.remove(sid);
        session = null;
    }
    
    /**
     * ɓnꂽZbVIDɌѕtĂAUserIuWFNgԂB
     *
     * @param  sid ZbVID
     * @return ZbVIDɌѕtĂUser
     * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
     * @see jp.co.argo21.nautica.workflow.security.SessionManager#getSessionUser(java.lang.String)
     */
    public User getSessionUser(String sid)
    throws InvalidSessionException
    {
        /* ZbV擾BȂΗO𓊂B*/
        Session session = (Session) sessions.get(sid);
        if (session == null) {
            // ȃZbVw肳܂B
            String errMsg = StringManager.get("E1015")
                + "(SessionID=" + sid + ")";
            sLog.error(errMsg);
            throw new InvalidSessionException(errMsg);
        }
        
        /* [U擾 */
        try {
            User user = session.getUser();
            return user;
            
        } catch (WorkflowException e) {
            // [U̎擾Ɏs܂B
            String errMsg = StringManager.get("E1010")
                + "(SessionID=" + sid + ")";
            sLog.error(errMsg);
            throw new InvalidSessionException(errMsg, e);
        }
    }
    
    /**
     * 莞ԂƂɁA^CAEgꂽZbV
     * Ǘ͂B
     */
    private void timerRaised() {
        /* ǗɂZbV̂ALԂ𒴉߂Ă̂擾 */
        Set timeouts = new HashSet();
        Iterator iter = sessions.keySet().iterator();
        while (iter.hasNext()) {
            String sid = (String) iter.next();
            Session session = (Session) sessions.get(sid);
            
            try {
                long notAccessedTerm
    		    = System.currentTimeMillis() - session.getLastAccessedTime().getTime(); 
                
                if (notAccessedTerm >= VALIDTERM) {
                    timeouts.add(sid);
                }
                
            } catch (WorkflowException e) {
                // ŏIANZXԂ̎擾Ɏs܂B
    			String warnMsg = StringManager.get("E1016");
                sLog.error(warnMsg, e);
            }
        }
        
        /* LԂ𒴉߂ZbV𖳌 */
        Iterator timeoutIter = timeouts.iterator();
        while (timeoutIter.hasNext()) {
            String timeoutSID = (String) timeoutIter.next();
            try {
                invalidateSession(timeoutSID);
                
            } catch (InvalidSessionException e) {
                /* O͓AOo͂̂ */
                sLog.warn(e.getMessage(), e);
            }
        }
    }
        
    /**
     * ZbV^CAEgNNXB
     * SimpleSessionManager ^C}ɂċNB
     * 
     * @author mmanabe(Argo 21, Corp.)
     * @version $Revision: 1.15 $
     * @since   Nautica Workflow 0.9
     */
    private class TimeoutTimerTask extends TimerTask {

        private SimpleSessionManager ssm;
        
        /**
         * TimeoutTimerTask 𐶐B
         * 
         * @param ssm SimpleSessionManager IuWFNg
         */
        TimeoutTimerTask(SimpleSessionManager ssm) {
            this.ssm = ssm;
        }
        
        /**
         * ZbV^CAEǧmB
         * ۂ̏ SimpleSessionManager#timerRaised \bhōsB
         * 
         * @see java.util.TimerTask#run()
         */
        public void run() {
            ssm.timerRaised();
        }
    }
}