/* $Id: SimpleUserManager.java,v 1.14 2005/08/26 04:55:34 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import javax.naming.Context;
import javax.naming.InitialContext;

import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

import org.apache.log4j.Logger;

/**
 * {[Nt[VXe^pՋyъO痘p郆[UǗ֘A
 * eAPI񋟂QlłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.14 $
 * @since   Nautica Workflow 0.9
 */
public class SimpleUserManager implements UserManager {

	private static final String WORKFLOW_USER_MANAGER 
		= "WorkflowUserManager";

	private static Logger sLog = LogManager.getSercurityLogger(); 
	
	/**
	 * SimpleUserManager 𐶐B
	 * 
	 * @throws Exception [UǗ̌JɎsꍇ
	 */
	public SimpleUserManager() throws Exception {
		try {
			UserManagerPO umPO = new UserManagerPO(this);
			Context context = new InitialContext();
			context.rebind(WORKFLOW_USER_MANAGER, umPO);
			sLog.info(StringManager.get("I1005"));
		
		} catch (Exception ex) {
			// [UǗ̌JɎs܂B
			String errMsg = StringManager.get("E1008");
			sLog.error(errMsg, ex);
			throw ex;
		}
	}
	
	/**
	 * uidɑΉ郆[UԂB
	 * uidɑΉ郆[U݂Ȃꍇ null ԂB
	 *
	 * @param  uid [UID
	 * @return [U
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 */
	public User getUser(String uid) throws WorkflowSecurityException {
		
	    try {	        
	        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
	        UserManagerDAO usermanagerDAO = daoFactory.getUserManagerDAO();
	        
	        User user = usermanagerDAO.findByUserID(uid);
	        return user;
	        
	    } catch (Exception e) {
	        // [U̎擾Ɏs܂B
	        String errMsg = StringManager.get("E1010") + "(UserID = " + uid + ")";
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg , e);
	    }
	}
}
