/* $Id: UserManagerRemote.java,v 1.4 2005/08/26 04:55:32 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.rmi.Remote;
import java.rmi.RemoteException;

import jp.co.argo21.nautica.workflow.security.InvalidRoleException;
import jp.co.argo21.nautica.workflow.security.InvalidUserException;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

/**
 * UserManagerRemote ́A[UǗ֘ÅeAPI`B
 * GWOĂяo邱Ƃz肵[gC^tF[XłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public interface UserManagerRemote extends Remote {

	/**
	 * uidɑΉ郆[UԂB
	 * uidɑΉ郆[U݂Ȃꍇ null ԂB
	 *
	 * @param uid [UID
	 * @return [U
	 * @throws InvalidRoleException w肳ꂽ[ULłȂꍇ
	 * @throws WorkflowSecurityException ̑̃ZLeBO
	 * @throws RemoteException RemoteException 
	 */
	public User getUser(String uid)
	throws InvalidUserException, WorkflowSecurityException, RemoteException;
}
