/* $Id: AbstractToolAgentMessageAdapter.java,v 1.6 2005/08/26 04:52:59 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.sql.Connection;
import java.sql.Timestamp;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowServiceManager;

/**
 * c[G[WFgpbZ[WA_v^̒ۃNX
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public abstract class AbstractToolAgentMessageAdapter extends WorkflowMessageAdapter {
    
    /* OIuWFNg */
    protected Logger log = LogManager.getLogger(this.getClass());
    
    /**
     * RXgN^
     */
    AbstractToolAgentMessageAdapter() {
        super();
    }

    /**
     * AvP[V̏Ԃ擾B
     * 
     * AvP[V̏ԂAvP[Vse[u擾B<br>
     * AvP[Vse[uɊỸR[h݂Ȃꍇ́A
     * PbԊuŁAXɂSivTjsB<br>
     * łAvP[Vse[uɃR[h݂Ȃꍇ́A
     * OWorkflowException𓊂B
     *
     * @param conn	RlNV
     * @param info	AvP[Vs
     * @return	AvP[V
     * @throws Exception	Ԃ̎擾Ɏsꍇ
     */
    protected AppExecutionBean getApplicationState(Connection conn, AppExecutionInfo info) 
    	throws Exception {

        AppExecutionBean bean = null;
        AppExecutionDAO appExecutionDao = null;
        
        // AvP[Vse[u(APPEXEC)e[u
        // AvP[V̏Ԃ擾B
        WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
        appExecutionDao = factory.getAppExecutionDAO(conn);
        // AvP[Vse[uINSERT܂őҋ@
        // 1bԊu5Ďs
        for (int cnt = 0; cnt < 5 && bean == null; cnt++) {
            // ȊO1b(1000~b)ҋ@
            if (cnt != 0) {
                Thread.sleep(1000L);
            }
            // AvP[Vse[u
            bean = appExecutionDao.findByPrimaryKey(info.getAppName(), info.getToolAgent(), info.getHandler());
        }
        if (bean == null) {
            // 5ČĂAvP[Vse[uɃR[hȂꍇ́A
            // OɃG[bZ[Wo͂āAs߂B
            String errMsg = StringManager.get("E2009")
            	+ "APPNAME=" + info.getAppName() + ", "
            	+ "TOOL_AGENT=" + info.getToolAgent() + ", "
            	+ "EXEC_ID=" + info.getHandler();
            log.error(errMsg);
            throw new WorkflowException(errMsg);
        }

        return bean;
    }
    
    /**
     * AvP[Vse[ȕԂύXB
     * 
     * @param conn	RlNV
     * @param info	AvP[Vs
     * @param oldState	
     * @param newState	V
     * @throws Exception	AvP[Vse[ȕԕύXɎsꍇ
     */
    protected void updateState(Connection conn, AppExecutionInfo info, 
            ApplicationState oldState, ApplicationState newState) throws Exception {
        
        WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
        AppExecutionDAO appExecutionDao = factory.getAppExecutionDAO(conn);
        appExecutionDao.updateState(info.getAppName(), info.getToolAgent(), info.getHandler(), oldState, newState);
    }
    
    /**
     * AvP[V̏I܂̓gCsB
     * 
     * AvP[VُIĂAȂs񐔂̒l̏ꍇ́A
     * AvP[ṼgCsB<br>
     * ȊȌꍇ́AAvP[Vse[uȈԂɕύXA
     * ƍڂɁAAvP[V̎sʒmB
     *
     * @param conn	RlNV
     * @param info	AvP[Vs
     * @param oldState	
     * @param result	AvP[VsʁB0͐IB0ȊOُ͈IB
     * @param agent		c[G[WFg
     * @throws Exception	AvP[ṼgCIɎsꍇ
     */
    protected void finalizeApplication(Connection conn, AppExecutionInfo info, 
            ApplicationState oldState, int result, AbstractToolAgent agent)
    throws Exception {
        
        if (result != 0 && info.getRetryCount() > 0) {
            agent.retryApplication(info);
            return; 
        }
        
        WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
        AppExecutionDAO appExecutionDao = factory.getAppExecutionDAO(conn);

        ApplicationState resultAppState = ApplicationState.TERMINATED;
        WorkItemState resultWorkState = WorkItemState.CLOSED_TERMINATED;
        if (result == 0) {
            resultAppState = ApplicationState.COMPLETED;
            resultWorkState = WorkItemState.CLOSED_COMPLETED;
        }
        
        appExecutionDao.updateState(info.getAppName(), info.getToolAgent(), info.getHandler(), 
                oldState, resultAppState, new Timestamp(System.currentTimeMillis()));
        
        // ƍڂɃAvP[VIƂʒm
        WorkflowServiceManager manager = WorkflowEngine.getInstance();
        String session = null;
        try {
            session = agent.connect();
            WorkItemHandler handler = manager.getWorkItemHandler(session);
            handler.changeWorkItemState(session, info.getWid(), resultWorkState);
        } finally {
            if (session != null) {
                agent.disconnect(session);
            }
        }
    }
}
