/* $Id: AppExecutionInfo.java,v 1.11 2005/08/26 04:52:49 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * AvP[VsNX
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
public abstract class AppExecutionInfo implements WorkflowMessage {

    /** AvP[V */
    protected String appName;
    
    /** ƍID */
    protected String wid;
    
    /** c[G[WFg̃NX */
    protected String toolAgent;
    
    /** c[G[WFgnh */
    protected int handler = 0;
    
    /** ꗗ */
    protected Attribute[] attributes;
    
    /** c[G[WFgs */
    protected int retryCount = 1;
    
    /**
     * AvP[VsIuWFNg𐶐B
     *
     */
    public AppExecutionInfo() {
        // ȂB
    }
    
    /**
     * AvP[VԂB
     *
     * @return AvP[V
     */
    public String getAppName() {
        return appName;
    }
    
    /**
     * AvP[Vݒ肷B
     * 
     * @param appName AvP[V
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }
    
    /**
     * c[G[WFg̃NXԂB
     *
     * @return c[G[WFg̃NX
     */
    public String getToolAgent() {
        return toolAgent;
    }
    
    /**
     * c[G[WFg̃NXݒ肷B
     * 
     * @param toolAgent c[G[WFg̃NX
     */
    public void setToolAgent(String toolAgent) {
        this.toolAgent = toolAgent;
    }
    
    /**
     * c[G[WFgnhԂB
     *
     * @return	c[G[WFgnh
     */
    public int getHandler() {
        return handler;
    }
    
    /**
     * c[G[WFgnhݒ肷B
     *
     * @param handler	c[G[WFgnh
     */
    public void setHandler(int handler) {
        this.handler = handler;
    }
    
    /**
     * ꗗԂB
     *
     * @return ꗗ
     */
    public Attribute[] getAttributes() {
        return attributes;
    }
    
    /**
     * ꗗݒ肷B
     * 
     * @param attrList ꗗ
     */
    public void setAttributes(Attribute[] attrList) {
        this.attributes = attrList;
    }
    
    /**
     * ƍIDԂB
     *
     * @return ƍID
     */
    public String getWid() {
        return wid;
    }
    
    /**
     * ƍIDݒ肷B
     * 
     * @param wid ƍID
     */
    public void setWid(String wid) {
        this.wid = wid;
    }
    
    /**
     * s񐔂擾B
     *
     * @return	s
     */
    public int getRetryCount() {
        return retryCount;
    }
    
    /**
     * s񐔂ݒ肷B
     * 
     * @param count		s
     */
    public void setRetryCount(int count) {
        this.retryCount = count;
    }
    
    /**
     * IuWFNg̕\Ԃ܂B
     *
     * @return	̃IuWFNg̕\
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ApplicationName=").append(this.appName).append(", ");
        buf.append("WorkItemID=").append(this.wid).append(", ");
        buf.append("ToolAgentClassName=").append(this.getToolAgent()).append(", ");
        buf.append("ToolAgentHandler=").append(this.handler).append(", ");
        buf.append("Attributes=").append(this.attributes).append(", ");
        buf.append("RetryCount=").append(this.retryCount);
        return new String(buf);
    }
}
