/* $Id: ApplicationState.java,v 1.5 2005/08/26 04:52:55 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import jp.co.argo21.nautica.workflow.omg.WfState;

/**
 * AvP[V̏Ԃ\IuWFNgłB
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public final class ApplicationState implements WfState {

    /** I(0Fcompleted) */
	static public final ApplicationState COMPLETED
		= new ApplicationState("completed", 0);

	/** ُI(1Fterminated) */
	static public final ApplicationState TERMINATED
		= new ApplicationState("terminated", 1);

	/** Jn(2Fnot_started) */
	static public final ApplicationState NOT_STARTED
		= new ApplicationState("not_started", 2);

	/** ~(3Fsuspended) */
	static public final ApplicationState SUSPENDED
		= new ApplicationState("suspended", 3);

	/** s(6Frunning) */
	static public final ApplicationState RUNNING
		= new ApplicationState("running", 6);

	/** ʕs(9Funknown) */
	static public final ApplicationState UNKNOWN
		= new ApplicationState("unknown", 9);
	
	/** ԕ */
	private String stateString;
	
	/** Ԓl */
	private int stateNum;
	
	/**
	 * AvP[V̏ԂԂ
	 *
	 * @param i		AvP[V̏Ԃ̐l\B
	 * 				YԂȂꍇ́AApplicationState.UNKNOWNԂB
	 * @return	AvP[V̏
	 */
	public static ApplicationState toApplicationState(int i) {
	    ApplicationState state = null;
	    switch(i) {
	    case 0:
	        state = COMPLETED;
	        break;
	    case 1:
	        state = TERMINATED;
	        break;
	    case 2:
	        state = NOT_STARTED;
	        break;
	    case 3:
	        state = SUSPENDED;
	        break;
	    case 6:
	        state = RUNNING;
	        break;
	    case 9:
	    default:
	        state = UNKNOWN;
	        break;
	    }
	    return state;
	}
	
	/**
	 * AvP[V̏Ԃ𐶐B
	 * 
	 * @param s ԕ
	 * @param i Ԓl
	 */
	private ApplicationState(String s, int i)
	{
		stateString = s;
		stateNum = i;
	}

	/**
	 * Ԃ̕\ԂB
	 * 
	 * @return Ԃ̕\
	 */
	public String toString()
	{
		return stateString;
	}

	/**
	 * Ԃ̐l\ԂB
	 * 
	 * @return Ԃ̐l\
	 */
	public int toInt()
	{
		return stateNum;
	}
}
