/* $Id: MailConfig.java,v 1.6 2005/08/26 04:52:51 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.util.HashMap;
import java.util.Map;

import jp.co.argo21.nautica.workflow.ta.config.App;
import jp.co.argo21.nautica.workflow.ta.config.Auth;
import jp.co.argo21.nautica.workflow.ta.config.Receiver;
import jp.co.argo21.nautica.workflow.ta.config.Server;
import jp.co.argo21.nautica.workflow.ta.config.Servers;
import jp.co.argo21.nautica.workflow.ta.config.MailDocument.Mail;

/**
 * [MpݒIuWFNg
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class MailConfig {
    
    /**
     * [UID
     */
    private String user = null;
    
    /**
     * pX[h
     */
    private String password = null;
    
    /**
     * AvP[Vƃ[T[ȏΉ\
     */
    private Map applications = new HashMap();
    
    /**
     * tRXgN^
     *
     * @param mali
     */
    MailConfig(Mail mali) {
        // c[G[WFgX̔F؏̐ݒ
        this.user = mali.getAuthentication().getUser();
        this.password = mali.getAuthentication().getPassword();
        
        // AvP[VƃT[oݒ̃}bsO
        Servers serverlist = mali.getServers();
        if (serverlist == null) {
            return;
        }
        Server[] servers = serverlist.getServerArray();
        for (int i = 0; i < servers.length; i++) {
            Server server = servers[i];
            App[] apps = servers[i].getAppArray();
            for (int j = 0; j < apps.length; j++) {
                this.applications.put(apps[j].getName(), server);
            }
        }
    }
    
    /**
     * AvP[VɑΉ[T[o̐ݒ擾
     *
     * @param appName
     * @return	R}h
     */
    private Server getServer(String appName)
    {
        return (Server)this.applications.get(appName);
    }
    
    /**
     * [T[o̔F؃^Cv擾B
     * 
     * ftHgł normal ԂB<br>
     * AvP[VɊY郁[T[o̐ݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	[T[o̔F؃^Cv
     */
    public String getAuthType(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getAuthType();
    }
   
    /**
     * MT[õvgR擾B
     * 
     * ftHgł smtp ԂB<br>
     * AvP[VɊY郁[T[o̐ݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õvgR
     */
    public String getSenderProtocol(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getSender().getProtocol();
    }
    
    /**
     * [M̃GR[h擾B
     * 
     * ftHgł iso-2022-jp ԂB<br>
     * AvP[VɊY郁[T[o̐ݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	[M̃GR[h
     */
    public String getSenderEncode(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getSender().getEncode();
    }
    
    /**
     * [MMIME-Type擾B
     * 
     * ftHgł "text/plain" ԂB<br>
     * AvP[VɊY郁[T[o̐ݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	[MMIME-Type
     */
    public String getSenderMimeType(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getSender().getMimeType();
    }
    
    /**
     * MT[õzXgAhX擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õzXgAhXB
     */
    public String getSenderHostAddress(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getSender().getHost().getAddress();
    }
    
    /**
     * MT[õ|[gԍ擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂Ȃꍇ -1 ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õ|[gԍB
     */
    public int getSenderHostPort(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return -1;
        }
        return server.getSender().getHost().getPort();
    }
    
    /**
     * MT[õ[U擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂ȂꍇA
     * MT[oŔF؂sȂꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õ[UB
     */
    public String getSenderHostUser(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        Auth auth = server.getSender().getAuthentication();
        if (auth == null) {
            return null;
        }
        return auth.getUser();
    }
    
    /**
     * MT[õpX[h擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂ȂꍇA
     * MT[oŔF؂sȂꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õ[U
     */
    public String getSenderHostPassword(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        Auth auth = server.getSender().getAuthentication();
        if (auth == null) {
            return null;
        }
        return auth.getPassword();
    }
    
    /**
     * MT[õvgR擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂ȂꍇA
     * MT[ogpȂꍇ́Anull ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õvgR
     */
    public String getReceiverProtocol(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return null;
        }
        return receiver.getProtocol();
    }
    
    /**
     * MT[õzXgAhX擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂ȂꍇA
     * MT[ogpȂꍇ́Anull ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õzXgAhXB
     */
    public String getReceiverHostAddress(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return null;
        }
        return receiver.getHost().getAddress();
    }
    
    /**
     * MT[õ|[gԍ擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂ȂꍇA
     * MT[ogpȂꍇ́A-1 ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õ|[gԍ
     */
    public int getReceiverHostPort(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return -1;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return -1;
        }
        return receiver.getHost().getPort();
    }
    
    /**
     * MT[õ[U擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂ȂꍇA
     * MT[ogpȂꍇ́Anull ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õ[U
     */
    public String getReceiverHostUser(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return null;
        }
        return receiver.getAuthentication().getUser();
    }
    
    /**
     * MT[õpX[h擾B
     * 
     * AvP[VɊY郁[T[o̐ݒ肪݂ȂꍇA
     * MT[ogpȂꍇ́Anull ԂB
     *
     * @param appName	AvP[V
     * @return	MT[õpX[h
     */
    public String getReceiverHostPassword(String appName) {
        Server server = getServer(appName);
        if (server == null) {
            return null;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return null;
        }
        return receiver.getAuthentication().getPassword();
    }
    
    /**
     * p[^̃AvP[Vݒɑ݂邩ǂ`FbN
     *
     * @param appName
     * @return	ݒɎw肵AvP[V݂ꍇAtrue
     */
    public boolean existApplication(String appName)
    {
        return this.applications.containsKey(appName);
    }
    
    /**
     * [UID擾
     *
     * @return	[UID
     */
    public String getUser() {
        return this.user;
    }
    
    /**
     * pX[h擾
     *
     * @return	pX[h
     */
    public String getPassword() {
        return this.password;
    }
}
