/* $Id: MailExecutionInfo.java,v 1.5 2005/08/26 04:52:53 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * [Mc[G[WFgp̃AvP[VsNX
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class MailExecutionInfo extends AppExecutionInfo {

    /* [Mps̃bZ[W^Cv */
    private static final int MESSAGE_TYPE = 802;
    
    /* [M */
    private InternetAddress from = null;
    
    /* [M(TO) */
    private InternetAddress[] to = null;
    
    /* [M(CC) */
    private InternetAddress[] cc = null;
    
    /* [M(BCC) */
    private InternetAddress[] bcc = null;
    
    /* [^Cg */
    private String subject = null;
    
    /* [{ */
    private String body = null;
    
    /* Ytt@C */
    private String[] attachmentFiles = null;
    
    /**
     * tRXgN^
     *
     * @param appName		AvP[V
     * @param toolAgent		c[G[WFg̃NX
     * @param wid			ƍID
     * @param handler		c[G[WFgnhiƍIDj
     * @param attrList		Xg
     */
    MailExecutionInfo(String appName, String toolAgent, String wid, 
            int handler, Attribute[] attrList) {
        this.setAppName(appName);
        this.setToolAgent(toolAgent);
        this.setWid(wid);
        this.setHandler(handler);
        this.setAttributes(attrList);
    }
    
	/**
	 * bZ[W̎ނ\lԂB
	 * 1-1000܂ł́A{[Nt[^pՂŃU[ûƂB
	 *
	 * @return bZ[W̎ނ\l
     * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessage#getMessageType()
     */
	public int getMessageType() {
	    return MESSAGE_TYPE;
	}
	
	/**
	 * M̃AhX擾B
	 * 
	 * ̃\bhsOɂ́AKparse\bhgp邱ƁB
	 * parse\bhgpO͕KnullԂB
	 * MAhXw肳ĂȂꍇ́AnullԂB
	 *
	 * @return	MAhX
	 */
	public InternetAddress getFrom() {
	    return this.from;
	}
	
	/**
	 * M(TO)̃AhX擾B
	 * 
	 * ̃\bhsOɂ́AKparse\bhgp邱ƁB
	 * parse\bhgpO͕KnullԂB
	 * MAhXw肳ĂȂꍇ́A̔z񂪕ԂB
	 *
	 * @return	M(TO)AhX
	 */
	public InternetAddress[] getTo() {
	    return this.to;
	}
	
	/**
	 * M(CC)̃AhX擾B
	 * 
	 * ̃\bhsOɂ́AKparse\bhgp邱ƁB
	 * parse\bhgpO͕KnullԂB
	 * MAhXw肳ĂȂꍇ́A̔z񂪕ԂB
	 *
	 * @return	M(CC)AhX
	 */
	public InternetAddress[] getCC() {
	    return this.cc;
	}
	
	/**
	 * M(TO)̃AhX擾B
	 * 
	 * ̃\bhsOɂ́AKparse\bhgp邱ƁB
	 * parse\bhgpO͕KnullԂB
	 * MAhXw肳ĂȂꍇ́A̔z񂪕ԂB
	 *
	 * @return	M(TO)AhX
	 */
	public InternetAddress[] getBCC() {
	    return this.bcc;
	}
	
	/**
	 * [^Cg擾B
	 * 
	 * [^Cg̓GR[hĂȂ̂ŁA
	 * ݒ莞ɃGR[hw肵ăGR[h邱ƁB
	 *
	 * @return	[^Cg
	 */
	public String getSubject() {
	    return this.subject;
	}
	
	/**
	 * [{擾B
	 * 
	 * [{̓GR[hĂȂ̂ŁA
	 * ݒ莞ɃGR[hw肵ăGR[h邱ƁB
	 *
	 * @return	[{
	 */
	public String getBody() {
	    return this.body;
	}
	
	/**
	 * Ytt@C̃Xg擾B
	 * 
	 * [ɓYtt@C̐΃pX̔z擾B
	 * ̃\bhsOɂ́AKparse\bhgp邱ƁB
	 * parse\bhgpO͕KnullԂB
	 * Ytt@Cw肳ĂȂꍇ́A̔z񂪕ԂB
	 *
	 * @return	Ytt@C̐΃pX̔z
	 */
	public String[] getAttachmentFiles() {
	    return this.attachmentFiles;
	}
	    
	
	/**
	 * [MpɃp[^߂B
	 * 
	 * @param	encode	GR[h
	 * @throws AddressException	MAMAhX RFC822 \ɏĂȂꍇ
	 * @throws UnsupportedEncodingException	T|[gĂȂGR[hw肵ꍇ
	 */
	public void parse(String encode) 
		throws AddressException, UnsupportedEncodingException {
	    
	    // M̐ݒ
	    from = parseInternetAddress("MAIL_FROM_ADDRESS", "MAIL_FROM_NAME", encode);
	    // M(TO)̐ݒ
	    to = parseInternetAddresses("MAIL_TO_ADDRESS", "MAIL_TO_NAME", encode);
	    // M(CC)̐ݒ
	    cc = parseInternetAddresses("MAIL_CC_ADDRESS", "MAIL_CC_NAME", encode);
	    // M(BCC)̐ݒ
	    bcc = parseInternetAddresses("MAIL_BCC_ADDRESS", "MAIL_BCC_NAME", encode);
	    
	    // [^Cg̐ݒ
	    for (int i = 0; i < this.attributes.length; i++) {
	        Attribute attr = this.attributes[i];
	        if (attr.getName().equals("MAIL_SUBJECT")) {
	            this.subject = attr.getValue();
	            break;
	        }
	    }
	    
	    // [{̐ݒ
	    StringBuffer buf = new StringBuffer();
	    for (int i = 0; i < this.attributes.length; i++) {
	        Attribute attr = this.attributes[i];
	        if (attr.getName().equals("MAIL_BODY")) {
	            buf.append(attr.getValue());
	        }
	    }
	    String str = new String(buf);
	    if (str != null) {
	        this.body = str;
	    }
	    
	    // Ytt@C̐ݒ
	    List tempList = new ArrayList();
	    for (int i = 0; i < this.attributes.length; i++) {
	        Attribute attr = this.attributes[i];
	        if (attr.getName().equals("MAIL_ATTACHMENT_FILE")) {
	            tempList.add(attr.getValue());
	        }
	    }
	    this.attachmentFiles = (String[])tempList.toArray(new String[0]);
	    
	}
	
	/**
	 * [M̃p[^͂āAInternetAddressIuWFNg𐶐B
	 * 
	 * [M̃p[^Aw肳ꂽp[^̃AhXƌl擾A
	 * InternetAddressIuWFNg𐶐B<br>
	 * p[^̒̕l݂ꍇ́Aŏ̒lgpB
	 *
	 * @param addr	AhX̃p[^
	 * @param personal	l̃p[^
	 * @param encode	GR[h
	 * @return	InternetAddressIuWFNg
	 * @throws AddressException	AhX RFC822 \ɏĂȂꍇ
	 * @throws UnsupportedEncodingException	T|[gĂȂGR[hw肵ꍇ
	 */
	private InternetAddress parseInternetAddress(String addr, String personal, String encode) 
		throws AddressException, UnsupportedEncodingException {
	    
	    // AhX擾
	    String address = null;
	    for (int i = 0; i < this.attributes.length; i++) {
	        Attribute attr = this.attributes[i];
	        if (attr.getName().equals(addr)) {
	            address = attr.getValue();
	            break;
	        }
	    }
	    // ̂擾
	    String name = null;
	    for (int i = 0; i < this.attributes.length; i++) {
	        Attribute attr = this.attributes[i];
	        if (attr.getName().equals(personal)) {
	            name = attr.getValue();
	            break;
	        }
	    }
	    
	    InternetAddress result = null;
	    if (name != null) {
	        result = new InternetAddress(address, name, encode);
	    } else {
	        result = new InternetAddress(address);
	    }
	    return result;
	}
	
	/**
	 * [M̃p[^͂āAInternetAddressIuWFNg̔z𐶐B
	 * 
	 * [M̃p[^Aw肳ꂽp[^̃AhXƌl擾A
	 * InternetAddressIuWFNg̔z𐶐B
	 *
	 * @param addr	AhX̃p[^
	 * @param personal	l̃p[^
	 * @param encode	GR[h
	 * @return	InternetAddressIuWFNg̔z
	 * @throws AddressException	AhX RFC822 \ɏĂȂꍇ
	 * @throws UnsupportedEncodingException	T|[gĂȂGR[hw肵ꍇ
	 */
	private InternetAddress[] parseInternetAddresses(String addr, String personal, String encode)
		throws AddressException, UnsupportedEncodingException {
	    
	    // AhX擾
	    List addresses = new ArrayList();
	    for (int i = 0; i < this.attributes.length; i++) {
	        Attribute attr = this.attributes[i];
	        if (attr.getName().equals(addr)) {
	            addresses.add(attr.getValue());
	        }
	    }
	    // AhX擾
	    List names = new ArrayList();
	    for (int i = 0; i < this.attributes.length; i++) {
	        Attribute attr = this.attributes[i];
	        if (attr.getName().equals(personal)) {
	            names.add(attr.getValue());
	        }
	    }
	    // ݒ
	    List tempList = new ArrayList();
	    for (int i = 0; i < addresses.size(); i++) {
	        String address = (String)addresses.get(i);
	        String name = null;
	        if (i < names.size()) {
	            name = (String)names.get(i);
	        }
	        InternetAddress temp = null;
	        if (name != null) {
	            temp = new InternetAddress(address, name, encode);
	        } else {
	            temp = new InternetAddress(address);
	        }
	        tempList.add(temp);
	    }
	    
	    return (InternetAddress[])tempList.toArray(new InternetAddress[0]);
	}
}
