/* $Id: MailMessageAdapter.java,v 1.7 2005/08/26 04:52:50 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.util.Date;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.sql.DataSource;

import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * [MspNX
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class MailMessageAdapter extends AbstractToolAgentMessageAdapter {
    
    /* [wb_X-Mailerɐݒ肷l */
    private static final String MAILER_NAME = "nautica 0.9/MailAgent";

    /**
     * ftHgRXgN^
     */
    MailMessageAdapter() {
        super();
    }
    
    /**
     * [𑗐MB
     * 
     * ݒƃAvP[Vsɏ]ă[𑗐MB
     * s󋵂ɍ킹āAAAvP[Vse[u(APPEXEC)
     * XVB
     * 
     * @param	message	AvP[Vs
     * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter#onMessage(jp.co.argo21.nautica.workflow.jms.WorkflowMessage)
     */
    public void onMessage(WorkflowMessage message) {
        
        if (!MailExecutionInfo.class.isAssignableFrom(message.getClass())) {
            return;
        }
        MailExecutionInfo info = (MailExecutionInfo)message;
        
        Connection conn = null;
        AppExecutionBean bean = null;
        AbstractToolAgent agent = null;
        try {
            // [M̐ݒ擾
            MailConfig config = MailConfigFactory.getConfig();
            agent = (AbstractToolAgent)(new MailToolAgentFactory()).getToolAgent();

            DataSource ds = DataAccessManager.getDataSource();
            conn = ds.getConnection();
            bean = getApplicationState(conn, info);
            conn.setAutoCommit(false);
            updateState(conn, info, bean.getAppState(), ApplicationState.RUNNING);
            
            log.info(StringManager.get("I2009"));
            // [𑗐M
            sendMail(config, info);
            // Oo
            log.info(StringManager.get("I2010"));
            // [M_ŁAs̏ԂɃR~bgB
            conn.commit();
            
        } catch (Exception ex) {
            // [MɎsꍇ
    	    
    	    // AvP[Vse[u(APPEXEC)e[u
    	    // AvP[V̏ԂύX
            try {
                conn.rollback();
                
                finalizeApplication(conn, info, ApplicationState.NOT_STARTED, -1, agent);
	        	// R~bg
	        	conn.commit();

	        	// Oo
                String errMsg = StringManager.get("E2011");
                log.error(errMsg , ex);
            
            } catch (Exception ex2) {
                // Oo
                String errMsg = StringManager.get("E2012");
                log.error(errMsg , ex);
            } finally {
                try {
                    if (conn != null && (!conn.isClosed())) {
                        conn.close();
                    }
                }catch (Exception ex2) {
                    /* Ignore */
                }
            }
            return;
        }

        try {
            // AvP[V̎sʂɉāA
            // AvP[Vse[uƍƍڂXVB
            finalizeApplication(conn, info, ApplicationState.RUNNING, 0, agent);
           	conn.commit();
        
        } catch (Exception ex) {
            try {
                // AvP[Vse[u(APPEXEC)e[u
                // AvP[V̏ԕύXɎsꍇ
                conn.rollback();
                // Oo
                log.error(StringManager.get("E2012") , ex);
            } catch (Exception ex2) {
                /* Ignore */
            }
            return;
        } finally {
            try {
                if (conn != null && (!conn.isClosed())) {
                    conn.close();
                }
            }catch (Exception ex) {
                /* Ignore */
            }
        }
    }
    
    /**
     * [Ms
     * 
     *
     * @param config
     * @param info
     * @throws AddressException
     * @throws UnsupportedEncodingException
     * @throws MessagingException
     */
    private void sendMail(MailConfig config, MailExecutionInfo info) 
    	throws AddressException, UnsupportedEncodingException, MessagingException {
        
        String appName = info.getAppName();
        String encode = config.getSenderEncode(appName);
        
        // AvP[Vs̃p[^烁[M̏߂
        info.parse(encode);
        
        Properties props = System.getProperties();
        // MT[õAhXw
        props.put("mail."+ config.getSenderProtocol(appName) + ".host",
                config.getSenderHostAddress(appName));
        props.put("mail.host", config.getSenderHostAddress(appName));
        
        // ZbV擾
        Session session = null;
        if (config.getSenderHostUser(appName) != null) {
            // SMTPF؂sꍇ
            Authenticator auth = new MailSendAuthenticator(
                        config.getSenderHostUser(appName),
                        config.getSenderHostPassword(appName));
            session = Session.getInstance(props, auth);
        } else if (config.getAuthType(appName).equals("pop-over-smtp")) {
            // POP over SMTP ŔF؂sꍇ
            session = Session.getInstance(props, null);
            Store store = session.getStore(config.getReceiverProtocol(appName));
            store.connect(config.getReceiverHostAddress(appName),
                    config.getReceiverHostPort(appName),
                    config.getReceiverHostUser(appName),
                    config.getReceiverHostPassword(appName));
    	} else {
    	    session = Session.getInstance(props, null);
    	}
        MimeMessage mimeMessage = new MimeMessage(session);

        // [wb_[̐ݒ
        // X-Mailerݒ
        mimeMessage.setHeader("X-Mailer", MAILER_NAME);
        // M[AhXƑMҖw
        mimeMessage.setFrom(info.getFrom());
        // M惁[AhXw
        mimeMessage.setRecipients(Message.RecipientType.TO, info.getTo());
        // CCw
        mimeMessage.setRecipients(Message.RecipientType.CC, info.getCC());
        // BCCw
        mimeMessage.setRecipients(Message.RecipientType.BCC, info.getBCC());
        // [̃^Cgw
        if (info.getSubject() == null) {
            mimeMessage.setSubject("No Subject", encode);
        } else {
            mimeMessage.setSubject(info.getSubject(), encode);
        }
        // [̌`w
        mimeMessage.setHeader("Content-Type", config.getSenderMimeType(appName));
        // Mtw
        mimeMessage.setSentDate(new Date(System.currentTimeMillis()));
        
        // Ytt@C݂ꍇ́AIɃ}`p[g[ɕύX
        if (info.getAttachmentFiles().length > 0) {
            // }`p[gbZ[W쐬
            MimeMultipart content = new MimeMultipart();
            MimeBodyPart text = new MimeBodyPart();
            text.setText(info.getBody(), encode);
            content.addBodyPart(text);
            // Ytt@C쐬
            String[] attachmentFileNames = info.getAttachmentFiles();
            for (int i=0; i < attachmentFileNames.length; i++) {
                File attachmentFile = new File(attachmentFileNames[i]);
                MimeBodyPart attachment = new MimeBodyPart();
                attachment.setDataHandler(
                        new DataHandler(new FileDataSource(attachmentFile)));
                attachment.setFileName(MimeUtility.encodeWord(attachmentFile.getName(), encode, null));
                content.addBodyPart(attachment);
            }
            // [Ƀ}`p[gbZ[WZbg
            mimeMessage.setContent(content);
        } else {
	        // [̓ew
	        mimeMessage.setText(info.getBody(), encode);
        }
        
        // M܂
        Transport.send(mimeMessage);
    }
    
    /**
     * lbg[NڑɕKvȔF؂擾邽߂̃IuWFNg
     *
     * @author  kiyoda(Argo 21, Corp.)
     * @version $Revision: 1.7 $
     * @since   Nautica Workflow 0.9
     */
    class MailSendAuthenticator extends Authenticator {
        
        /* [U */
        String user = null;
        /* pX[h */
        String password = null;
        
        /**
         * RXgN^
         *
         * @param user		[U
         * @param password	pX[h
         */
        MailSendAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }
        
        /**
         * pX[hF؂KvȏꍇɌĂяo܂B
         * 
         *
         * @return	PasswordAuthenticationB
         * @see javax.mail.Authenticator#getPasswordAuthentication()
         */
        protected PasswordAuthentication getPasswordAuthentication() {

            return new PasswordAuthentication(this.user, this.password);
        }
    }
}
