/* $Id: MailToolAgent.java,v 1.7 2005/08/26 04:52:45 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationBusyException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotDefinedException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotStoppedException;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.InvalidToolAgentException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;

/**
 * [Mpc[G[WFgNX
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class MailToolAgent extends AbstractToolAgent {

    /**
     * RXgN^
     *
     * @param userId	[UID
     * @param passwd	pX[h
     */
    MailToolAgent(String userId, String passwd) {
        this.userId = userId;
        this.passwd = passwd;
    }

    /**
	 * AvP[V̒~sB
	 *
	 * @param toolAgentHandle c[G[WFgnh
	 * @param wid ƍID
	 * @throws ApplicationNotStoppedException AvP[V~łȂꍇ
	 * @throws InvalidToolAgentException LłȂc[G[WFgnhw肵ꍇ
	 * @throws InvalidWorkItemException LłȂƍIDw肵ꍇ
	 * @throws ApplicationBusyException AvP[VrW[ŗv󂯂Ȃꍇ
     */
    public void terminateApplication(int toolAgentHandle, String wid)
            throws ApplicationNotStoppedException, InvalidToolAgentException,
            InvalidWorkItemException, ApplicationBusyException {
        
        // [M͑M̒~͏oȂ̂ŁA
        // KApplicationNotStoppedException 𓊂
        String errMsg = StringManager.get("E2002")
        	+ "(ToolAgentHandler=" + toolAgentHandle + ", "
        	+ "WorkItemID=" + wid + ")";
        log.error(errMsg);
        throw new ApplicationNotStoppedException(errMsg);
    }
    
    /**
     * AvP[VNc[G[WFg̃NX擾B
     * 
     * @return	AvP[VNc[G[WFg̃NX
     */
    protected String getToolAgentClassName() {
        return this.getClass().getName();
    }
    
    /**
     * AvP[Vs𑗐ML[擾B
     * 
     * c[G[WFgɃL[KvŁÃL[ɖOȂĂ͂ȂȂB
     * ̃L[̓c[G[WFgŗL̕łB
     * {Iɂ̓c[G[WFggpB
     * ec[G[WFgŏdȂ悤ɒӂ邱ƁB
     *
     * @return	L[
     */
    protected String getQueueName() {
        return MailToolAgentFactory.QUEUE_NAME;
    }
    
    /**
     * L[ɑMAvP[Vs擾B
     *
     * AvP[VsNXł́ȀɂāA
     * AvP[VsB 
     *
     * @param appName	`Ɏw肵AvP[V
     * @param wid		ƍID
     * @param handler	c[G[WFgnh
     * @param attrList	ꗗ
     * @return	AvP[Vs
     */
    protected AppExecutionInfo getExecInfo(String appName, String wid,
            int handler, Attribute[] attrList) 
    {
        return new MailExecutionInfo(appName, getToolAgentClassName(), 
                wid, handler, attrList);
    }
    
    /**
     * AvP[V`Ă邩ǂ`FbNB
     * 
     * AvP[V`ĂȂꍇAOB
     *
     * @param appName	AvP[V
     * @throws	ApplicationNotDefinedException	AvP[V`ĂȂꍇ
     * @see jp.co.argo21.nautica.workflow.ta.AbstractToolAgent#checkApplicationDefined(java.lang.String)
     */
    protected void checkApplicationDefined(String appName)
    	throws ApplicationNotDefinedException {
        
        MailConfig config = null;
        try {
	        config = MailConfigFactory.getConfig();
        } catch (Exception ex) {
            // G[
            String errMsg = StringManager.get("E2004")
            	+ "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg, ex);
        }
        
        if (config == null || !config.existApplication(appName)) {
            // G[
            String errMsg = StringManager.get("E2004")
        	+ "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg);
        }
    }
}
