/* $Id: ScriptingConfig.java,v 1.5 2005/08/26 04:52:52 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.util.HashMap;
import java.util.Map;

import jp.co.argo21.nautica.workflow.ta.config.App;
import jp.co.argo21.nautica.workflow.ta.config.Script;
import jp.co.argo21.nautica.workflow.ta.config.Scripts;
import jp.co.argo21.nautica.workflow.ta.config.ScriptingDocument.Scripting;

/**
 * XNvgspݒIuWFNg
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class ScriptingConfig {
    
    /**
     * [UID
     */
    private String user = null;
    
    /**
     * pX[h
     */
    private String password = null;
    
    /**
     * AvP[VƃXNvg̑Ή\
     */
    private Map applications = new HashMap();
    
    /**
     * tRXgN^
     *
     * @param scripting ScriptingIuWFNg
     */
    ScriptingConfig(Scripting scripting) {
        // c[G[WFgX̔F؏̐ݒ
        this.user = scripting.getAuthentication().getUser();
        this.password = scripting.getAuthentication().getPassword();
        
        // AvP[VƃXNvg̃}bsO
        Scripts scriptlist = scripting.getScripts();
        if (scriptlist == null) {
            return;
        }
        Script[] scripts = scriptlist.getScriptArray();
        for (int i = 0; i < scripts.length; i++) {
            Script script = scripts[i];
            App[] apps = scripts[i].getAppArray();
            for (int j = 0; j < apps.length; j++) {
                this.applications.put(apps[j].getName(), script);
            }
        }    
    }

    /**
     * p[^̃AvP[Vݒɑ݂邩ǂ`FbN
     *
     * @param appName@AvP[V
     * @return	ݒɎw肵AvP[V݂ꍇAtrue
     */
    public boolean existApplication(String appName)
    {
        return this.applications.containsKey(appName);
    }
    
    /**
     * [UID擾
     *
     * @return	[UID
     */
    public String getUser() {
        return this.user;
    }
    
    /**
     * pX[h擾
     *
     * @return	pX[h
     */
    public String getPassword() {
        return this.password;
    }
    
    /**
     * AvP[VɑΉXNvgݒ擾B
     * 
     * AvP[VɊYXNvgݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	XNvgݒ
     */
    private Script getScript(String appName) {
        return (Script)this.applications.get(appName);
    }
    
    /**
     * XNvgGW擾B
     * 
     * AvP[VɊYXNvgݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	XNvgGW
     */
    public String getEngineName(String appName) {
        Script script = getScript(appName);
        if (script == null) {
            return null;
        }
        return script.getEngine().getName();
    }
    
    /**
     * XNvg̎ނ擾B
     * 
     * sXNvgAR}hsȂ̂
     * t@CɋLqꂽXNvgŝ
     * w肵ĂXNvg̎ނ擾B
     * R}hs̏ꍇAcommand A
     * t@Cs̏ꍇAfile ԂB
     * AvP[VɊYXNvgݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	XNvg̎
     */
    public String getType(String appName) {
        Script script = getScript(appName);
        if (script == null) {
            return null;
        }
        return script.getType();
    }
    
    /**
     * XNvgt@C擾B
     * 
     * sXNvg̃t@C擾B
     * XNvgt@Cݒ肳ĂȂꍇ́AnullԂB
     * AvP[VɊYXNvgݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	XNvgt@C
     */
    public String getFilename(String appName) {
        Script script = getScript(appName);
        if (script == null) {
            return null;
        }
        return script.getFilename();
    }
    
    /**
     * XNvgR}h擾B
     * 
     * sXNvg̃R}h擾B
     * XNvgR}hݒ肳ĂȂꍇ́AnullԂB
     * AvP[VɊYXNvgݒ肪݂Ȃꍇ null ԂB
     *
     * @param appName	AvP[V
     * @return	XNvgR}h
     */
    public String getCommand(String appName) {
        Script script = getScript(appName);
        if (script == null) {
            return null;
        }
        return script.getCommand();
    }
}
