/* $Id: ScriptingConfigFactory.java,v 1.4 2005/08/26 04:52:48 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;

import jp.co.argo21.nautica.workflow.engine.WorkflowEngineConstants;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.ta.config.ScriptingDocument;
import jp.co.argo21.nautica.workflow.ta.config.ScriptingDocument.Scripting;
import jp.co.argo21.nautica.workflow.util.StringManager;

import org.apache.xmlbeans.XmlOptions;

/**
 * XNvgspݒIuWFNg̃t@NgNX
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class ScriptingConfigFactory {
    
    /**
     * ݒt@C
     */
    public static String CONFIG_FILENAME = "scriptingconfig.xml";

    /**
     * ݒt@C̍ŏIXV
     */
    private static long lastModified = 0; 
    
    /**
     * ݒIuWFNg̃VOg
     */
    private static ScriptingConfig config = null;
    
    /**
     * ftHgRXgN^
     */
    private ScriptingConfigFactory() {
        super();
    }
    
    /**
     * XNvgspݒIuWFNg擾
     *
     * @return	XNvgspݒIuWFNg
     * @throws WorkflowException
     */
    public static synchronized ScriptingConfig getConfig() throws WorkflowException {
        
        try {
            File configFile = new File(getConfigPath());
            if (config == null || lastModified < configFile.lastModified()) {
            	InputStream in = new FileInputStream(configFile);
            	XmlOptions opts = new XmlOptions();
            	opts.setCharacterEncoding("utf-8");
            	ScriptingDocument doc = 
                	ScriptingDocument.Factory.parse(in, opts);
            	Scripting scripting = doc.getScripting();
            	
            	// ݒIuWFNg쐬
            	config = new ScriptingConfig(scripting);
            	// ݒt@C̍ŏIXVXV
            	lastModified = configFile.lastModified();
            }
        } catch (Exception ex) {
            // G[
            String errMsg = StringManager.get("E2005");
            throw new WorkflowException(errMsg, ex);
        }
        return config;
    }

    /**
     * ݒt@C̃pX擾
     *
     * @return	ݒt@C̃pX
     * @throws WorkflowException
     */
	static private URI getConfigPath()	throws WorkflowException {
	    
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String conf = CONFIG_FILENAME;
		String separator = System.getProperty("file.separator");
		String path = home
		                   + separator + "config"
						   + separator + conf;
		File confFile = new File(path);
	
		if (! confFile.exists()) {
			throw new WorkflowException(path + " is not found.");
		}
		if (! confFile.isFile()) {
			throw new WorkflowException(path + " is not file.");
		}
		
		return confFile.toURI();
	}

}
