/* $Id: ScriptingExecutionInfo.java,v 1.6 2005/08/26 04:52:49 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * XNvgspc[G[WFg̃AvP[VsNX
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class ScriptingExecutionInfo extends AppExecutionInfo {

    /** XNvgɍƍIDnۂ̃L[ */
    public static final String NAUTICA_WID = "__NAUTICA_WID__";
    
    /* XNvgsps̃bZ[W^Cv */
    private static final int MESSAGE_TYPE = 803;
    
    /* XNvg̈i[p}bv */
    private Map parameters = new HashMap();
    
    /**
     * tRXgN^
     *
     * @param appName		AvP[V
     * @param toolAgent		c[G[WFg̃NX
     * @param wid			ƍID
     * @param handler		c[G[WFgnhiƍIDj
     * @param attrList		Xg
     */
    ScriptingExecutionInfo(String appName, String toolAgent, String wid, 
            int handler, Attribute[] attrList) {
        this.setAppName(appName);
        this.setToolAgent(toolAgent);
        this.setWid(wid);
        this.setHandler(handler);
        this.setAttributes(attrList);
        this.parse(attrList);
    }
    
	/**
	 * bZ[W̎ނ\lԂB
	 * 1-1000܂ł́A{[Nt[^pՂŃU[ûƂB
	 *
	 * @return bZ[W̎ނ\l
     * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessage#getMessageType()
     */
	public int getMessageType() {
	    return MESSAGE_TYPE;
	}
	
	/**
	 * XNvgs̃p[^擾B
	 * 
	 * XNvgŝ߂̃p[^i[ꂽMapIuWFNg
	 * ԂB
	 * p[^Ȃꍇ́AMapIuWFNgԂB
	 *
	 * @return	XNvgs̃p[^
	 */
	public Map getParameters() {
	    return this.parameters;
	}
	
	/**
	 * GW̃vZXϐz߂āA
	 * XNvgspp[^쐬B
	 *
	 * @param attrList	vZXϐz
	 */
	private void parse(Attribute[] attrList) {
	    
	    if (attrList == null) {
	        return;
	    }
	    // ܂̓L[PʂŒl܂Ƃ߂
	    Map nameMap = new HashMap();
	    for (int i = 0; i < attrList.length; i++) {
	        String name = attrList[i].getName();
	        List valueList = (List)nameMap.get(name);
	        if (valueList == null) {
	            valueList = new ArrayList();
	        }
	        valueList.add(attrList[i].getValue());
	        nameMap.put(attrList[i].getName(), valueList);
	    }
	    // p[^̒ľ^𐮗
	    Iterator iter = nameMap.keySet().iterator();
	    while (iter.hasNext()) {
	        String key = (String)iter.next();
	        List valueList = (List)nameMap.get(key);
	        if (valueList.size() > 1) {
	            String[] param = (String[])valueList.toArray(new String[0]);
	            parameters.put(key, param);
	        } else {
	            String param = (String)valueList.get(0);
	            parameters.put(key, param);
	        }
	    }
	}
}
