/* $Id: ScriptingMessageAdapter.java,v 1.10 2005/08/26 04:52:55 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;

import javax.script.Namespace;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleNamespace;
import javax.sql.DataSource;

import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * XNvgspNX
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
public class ScriptingMessageAdapter extends AbstractToolAgentMessageAdapter {

    /**
     * ftHgRXgN^
     */
    ScriptingMessageAdapter() {
        super();
    }
    
    /**
     * XNvgsB
     * 
     * AvP[Vsɏ]āAXNvgsB
     * s󋵂ɍ킹āAAAvP[Vse[u(APPEXEC)
     * XVB
     * 
     * @param	message	AvP[Vs
     * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter#onMessage(jp.co.argo21.nautica.workflow.jms.WorkflowMessage)
     */
    public void onMessage(WorkflowMessage message) {
        
        if (!ScriptingExecutionInfo.class.isAssignableFrom(message.getClass())) {
            return;
        }
        ScriptingExecutionInfo info = (ScriptingExecutionInfo)message;
        
        Connection conn = null;
        AppExecutionBean bean = null;
        int result = -1;
        AbstractToolAgent agent = null;
        try {
            // XNvgs̐ݒ擾
            ScriptingConfig config = ScriptingConfigFactory.getConfig();
            agent = (AbstractToolAgent)(new ScriptingToolAgentFactory()).getToolAgent();
            
            log.info(StringManager.get("I2011"));

            DataSource ds = DataAccessManager.getDataSource();
            conn = ds.getConnection();
            bean = getApplicationState(conn, info);
            conn.setAutoCommit(false);
            updateState(conn, info, bean.getAppState(), ApplicationState.RUNNING);
            // XNvgs
            result = execScript(config, info);
            // Oo
            log.info(StringManager.get("I2012"));
            conn.commit();

        } catch (Exception ex) {
            // XNvgɎsꍇ
    	    
    	    // AvP[Vse[u(APPEXEC)e[u
    	    // AvP[V̏ԂύX
            try {
                conn.rollback();
                
                finalizeApplication(conn, info, ApplicationState.NOT_STARTED, -1, agent);
	        	// R~bg
	        	conn.commit();

	        	// Oo
                String errMsg = StringManager.get("E2011");
                log.error(errMsg , ex);
            
            } catch (Exception ex2) {
                // Oo
                String errMsg = StringManager.get("E2012");
                log.error(errMsg , ex);
            } finally {
                try {
                    if (conn != null && (!conn.isClosed())) {
                        conn.close();
                    }
                }catch (Exception ex2) {
                    /* Ignore */
                }
            }
            return;
        }
        
        try {
            // AvP[V̎sʂɉāA
            // AvP[Vse[uƍƍڂXVB
            finalizeApplication(conn, info, ApplicationState.RUNNING, result, agent);
           	conn.commit();
        
        } catch (Exception ex) {
            try {
                // AvP[Vse[u(APPEXEC)e[u
                // AvP[V̏ԕύXɎsꍇ
                conn.rollback();
                // Oo
                log.error(StringManager.get("E2012") , ex);
            } catch (Exception ex2) {
                /* Ignore */
            }
            return;
        } finally {
            try {
                if (conn != null && (!conn.isClosed())) {
                    conn.close();
                }
            }catch (Exception ex) {
                /* Ignore */
            }
        }
    }
    
    /**
     * XNvgs
     * 
     * @param	config	XNvgݒ
     * @param	info	XNvgs
     * @return	s
     * @throws	ScriptException
     * @throws	FileNotFoundException 
     */
    private int execScript(ScriptingConfig config, ScriptingExecutionInfo info) 
    	throws ScriptException, FileNotFoundException {
        
        int result = 0;
        String appName = info.getAppName();
        String wid = info.getWid();

        // GW擾
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(config.getEngineName(appName));
        
        // XNvgւ̃p[^ݒ
        Namespace space = new SimpleNamespace();
        engine.setNamespace(space, ScriptContext.ENGINE_SCOPE);
 
        //ƍIDXNvgɈnB
        space.put(ScriptingExecutionInfo.NAUTICA_WID, wid);
        
        Map params = info.getParameters();
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = params.get(key);
            space.put(key, value);
        }
        
        if (config.getType(appName).equals("command")) {
            // XNvgR}hs
            engine.eval(config.getCommand(appName), space);
        } else {
            // XNvgt@Cs
        	String filename = getScriptingPath(config, appName);
            engine.eval(new FileReader(filename));
        }
	    
        return result;
    }
    
    /**
     * XNvgt@C̃pXԂB
     *
     * @param	config	XNvgݒ
     * @param appName	AvP[V
     * @return XNvgt@C̃pX
     */
    private String getScriptingPath(ScriptingConfig config, String appName) {

		String separator = System.getProperty("file.separator");
		String filename = config.getFilename(appName);
		File file = new File(filename);
		
		//΃pXȂ炻̂܂ܕԂB
		if (file.isAbsolute()) return filename;

		//ȊÓAɃ[JpX⊮ĕԂB
		return ScriptingToolAgent.LOCAL_SCRIPT_PATH
			+ separator
			+ config.getEngineName(appName)
			+ separator
			+ filename;
    }
}
