/* $Id: SystemCommandConfig.java,v 1.7 2005/08/26 04:52:58 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.util.HashMap;
import java.util.Map;

import jp.co.argo21.nautica.workflow.ta.config.App;
import jp.co.argo21.nautica.workflow.ta.config.SystemCommand;
import jp.co.argo21.nautica.workflow.ta.config.SystemCommandsDocument.SystemCommands;

/**
 * VXeR}hspݒIuWFNg
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class SystemCommandConfig {

    /**
     * [UID
     */
    private String user = null;
    
    /**
     * pX[h
     */
    private String password = null;
    
    /**
     * AvP[VƃR}h̑Ή\
     */
    private Map applications = new HashMap();
    
    /**
     * tRXgN^
     *
     * @param systemCommands SystemCommandsIuWFNg
     */
    SystemCommandConfig(SystemCommands systemCommands) {
        // c[G[WFgX̔F؏̐ݒ
        this.user = systemCommands.getAuthentication().getUser();
        this.password = systemCommands.getAuthentication().getPassword();
        
        // AvP[VƃR}h̃}bsO̐ݒ
        SystemCommand[] commands = systemCommands.getSystemCommandArray();
        for (int i = 0; i < commands.length; i++) {
            String command = commands[i].getCommand();
            App[] apps = commands[i].getAppArray();
            for (int j = 0; j < apps.length; j++) {
                this.applications.put(apps[j].getName(), command);
            }
        }
    }
    
    /**
     * AvP[VɑΉR}h擾
     *
     * @param appName@AvP[V
     * @return	R}h
     */
    public String getCommandString(String appName)
    {
        return (String)this.applications.get(appName);
    }
    
    /**
     * p[^̃AvP[Vݒɑ݂邩ǂ`FbN
     *
     * @param appName@AvP[V
     * @return	ݒɎw肵AvP[V݂ꍇAtrue
     */
    public boolean existApplication(String appName)
    {
        return this.applications.containsKey(appName);
    }
    
    /**
     * [UID擾
     *
     * @return	[UID
     */
    public String getUser() {
        return this.user;
    }
    
    /**
     * pX[h擾
     *
     * @return	pX[h
     */
    public String getPassword() {
        return this.password;
    }
}
