/* $Id: SystemCommandMessageAdapter.java,v 1.11 2005/08/26 04:52:57 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.util.ArrayList;
import java.util.List;
import java.io.File;
import java.sql.Connection;

import javax.sql.DataSource;

import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * VXeR}hspNX
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
class SystemCommandMessageAdapter extends AbstractToolAgentMessageAdapter {

    /**
     * ftHgRXgN^
     */
    SystemCommandMessageAdapter() {
        super();
    }
    
    /**
     * VXeR}hsB
     * 
     * AvP[Vsɏ]āAVXeR}hsB
     * s󋵂ɍ킹āAAAvP[Vse[u(APPEXEC)
     * XVB
     * 
     * @param	message	AvP[Vs
     * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter#onMessage(jp.co.argo21.nautica.workflow.jms.WorkflowMessage)
     */
    public void onMessage(WorkflowMessage message) {
        
        if (!SystemCommandExecutionInfo.class.isAssignableFrom(message.getClass())) {
            return;
        }
        SystemCommandExecutionInfo info = (SystemCommandExecutionInfo)message;
        
        Connection conn = null;
        AppExecutionBean bean = null;
        String command = null;
        Process process = null;
        AbstractToolAgent agent = null;
        try {
            // VXeR}h̐ݒ擾
            SystemCommandConfig config = SystemCommandConfigFactory.getConfig();
            agent = (AbstractToolAgent)(new SystemCommandToolAgentFactory()).getToolAgent();
            
            // R}h̎擾
            command = getCommandPath(config.getCommandString(info.getAppName()));
            if (command == null) {
                // Oo
                String errMsg = StringManager.get("E2008")
                	+ "(ApplicationExecutionInfomation=" + info + ")";
                log.error(errMsg);
                return;
            }
            log.info(StringManager.get("I2007") + "(ApplicationExecutionInfomation=" + info + ")");
            
            // s񂩂sR}hƈ܂ޔz쐬
            List list = new ArrayList();
            list.add(command);
            Attribute[] attrList = info.getAttributes();
            for (int i = 0; i < attrList.length; i++) {
                list.add(attrList[i].getValue());
            }
            String[] cmdarray = (String[])list.toArray(new String[] {});

            DataSource ds = DataAccessManager.getDataSource();
            conn = ds.getConnection();
            bean = getApplicationState(conn, info);
            conn.setAutoCommit(false);
            updateState(conn, info, bean.getAppState(), ApplicationState.RUNNING);
            // R}hs
            process = Runtime.getRuntime().exec(cmdarray);
            conn.commit();
            
        } catch (Exception ex) {
    	    // AvP[Vse[u(APPEXEC)e[u
    	    // AvP[V̏ԂύX
            try {
                conn.rollback();
                
                finalizeApplication(conn, info, ApplicationState.NOT_STARTED, -1, agent);
	        	// R~bg
	        	conn.commit();
                // Oo
                String errMsg = StringManager.get("E2011")
                	+ "(ApplicationExecutionInfomation=" + info + ")";
                log.error(errMsg , ex);
            
            } catch (Exception ex2) {
                // Oo
                String errMsg = StringManager.get("E2012")
                	+ "(ApplicationExecutionInfomation=" + info + ")";
                log.error(errMsg , ex);
            } finally {
                try {
                    if (conn != null && (!conn.isClosed())) {
                        conn.close();
                    }
                }catch (Exception ex2) {
                    /* Ignore */
                }
            }
            return;
            
        }
        
        try {
            // ProcessIuWFNgASystemCommandToolAgentɐݒ肷
            SystemCommandToolAgent.setProcess(info.getHandler(), process);
            
            // AvP[V̎s܂ŃXbhubN
            int result = process.waitFor();
            // O
            log.info(StringManager.get("I2008"));

            // AvP[V̎sʂɉāA
            // AvP[Vse[uƍƍڂXVB
            finalizeApplication(conn, info, ApplicationState.RUNNING, result, agent);
           	conn.commit();
        
        } catch (InterruptedException ex) {
            // AvP[VsɁAIꂽꍇ
    	    
    	    // AvP[Vse[u(APPEXEC)e[u
    	    // AvP[V̏ԂύX
            try {

                finalizeApplication(conn, info, ApplicationState.RUNNING, -1, agent);
	        	// R~bg
	        	conn.commit();
	            
	            // O
	            log.warn(StringManager.get("E2010") + "(ApplicationExecutionInfomation=" + info + ")");
            
            } catch (Exception ex2) {
                try {
                    conn.rollback();
                } catch (Exception e3) {
                    /* Ignore */
                }
                
                // Oo
                String errMsg = StringManager.get("E2012")
                	+ "(ApplicationExecutionInfomation=" + info + ")";
                log.error(errMsg , ex);
                return;
            }
            
        } catch (Exception ex) {
            try {
                // AvP[Vse[u(APPEXEC)e[u
                // AvP[V̏ԕύXɎsꍇ
                conn.rollback();
                // Oo
                log.error(StringManager.get("E2012") , ex);
            } catch (Exception ex2) {
                /* Ignore */
            }
            return;
        } finally {
            try {
                if (conn != null && (!conn.isClosed())) {
                    conn.close();
                }
            }catch (Exception ex) {
                /* Ignore */
            }
        }
    }
    
    /**
     * R}h̃pXԂB
     *
     * @param commandName	R}h
     * @return R}ht@C̃pX
     */
    private String getCommandPath(String commandName) {

		String separator = System.getProperty("file.separator");
		File file = new File(commandName);
		
		//΃pXȂ炻̂܂ܕԂB
		if (file.isAbsolute()) return commandName;

		//ȊÓAɃ[JpX⊮ĕԂB
		return SystemCommandToolAgent.LOCAL_COMMAND_PATH
			+ separator
			+ commandName;
    }
}
