/* $Id: SystemCommandToolAgent.java,v 1.15 2005/08/26 04:52:53 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationBusyException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotDefinedException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotStoppedException;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.InvalidToolAgentException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowServiceManager;

/**
 * VXeR}hpc[G[WFg̃NXB
 * 
 * AvP[VŐݒt@Cɓo^ꂽR}hsB<br>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.15 $
 * @since   Nautica Workflow 0.9
 */
public class SystemCommandToolAgent extends AbstractToolAgent {

    /* sEsς݃vZX */
    private static Map processes = Collections.synchronizedMap(new HashMap());
	/** [JXNvgzupX */
	static public final String LOCAL_COMMAND_PATH;

	static
	{
		String separator = System.getProperty("file.separator");
		LOCAL_COMMAND_PATH = TOOLAGENT_PATH + separator + "commands";
	}

    /**
     * RXgN^
     *
     * @param userId	[UID
     * @param passwd	pX[h
     */
    SystemCommandToolAgent(String userId, String passwd) {
        this.userId = userId;
        this.passwd = passwd;
    }

    /**
     * vZXݒ肷B
     * 
     * s̃vZXݒ肷B
     * ̂ƂɂAAvP[V̒~sƂo悤ɂȂB
     *
     * @param handle nhԍ
     * @param process vZXCX^X
     */
    public static void setProcess(long handle, Process process)
    {
        processes.put(new Long(handle), process);
    }
    
    /**
     * vZXԂB
     * 
     * @param	handle	c[G[WFgnh
     * @return	<code>Process</code>NX̃CX^XB
     * 			vZX݂Ȃꍇ́A<code>null</code>ԂB
     */
    protected static Process getProcess(long handle) {
        return (Process)processes.get(new Long(handle));
    }
    
    /**
	 * AvP[V̒~sB
	 *
	 * @param toolAgentHandle c[G[WFgnh
	 * @param wid ƍID
	 * @throws ApplicationNotStoppedException AvP[V~łȂꍇ
	 * @throws InvalidToolAgentException LłȂc[G[WFgnhw肵ꍇ
	 * @throws InvalidWorkItemException LłȂƍIDw肵ꍇ
	 * @throws ApplicationBusyException AvP[VrW[ŗv󂯂Ȃꍇ
     */
    public void terminateApplication(int toolAgentHandle, String wid)
            throws ApplicationNotStoppedException, InvalidToolAgentException,
            InvalidWorkItemException, ApplicationBusyException {
        
        // O
        String msg = StringManager.get("I2003") 
        	+ "(ToolAgentHandler=" + toolAgentHandle + ", "
        	+ "WorkItemID=" + wid + ")";
        log.info(msg);
        
        // c[G[WFgnhɑΉvZXIuWFNg擾
        Process process = getProcess(toolAgentHandle);
        
        // c[G[WFgnhɑΉvZXIuWFNg݂ȂꍇA
        // AvP[V~邱Ƃ͏oȂ߁AO𓊂
        if (process == null) {
            // O
            String errMsg = StringManager.get("E2002")
            	+ "(ToolAgentHandler=" + toolAgentHandle + ", "
            	+ "WorkItemID=" + wid + ")";
            log.error(errMsg);
            throw new InvalidToolAgentException(errMsg);
        }
        
        Connection conn = null;
        String session = null;
        try {
            DataSource ds = DataAccessManager.getDataSource();
            conn = ds.getConnection();
            // DAOFactory擾
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            // AppExecutionDAO擾
            AppExecutionDAO appExecutionDao = factory.getAppExecutionDAO(conn);
            // AppExecutionBean擾
            List beans = appExecutionDao.findByExecID(toolAgentHandle);
        
        	// APPEXECɃR[h1݂Ȃꍇ́AG[
            if (beans.size() != 1) {
                // G[
                String errMsg = StringManager.get("E2002")
                	+ "(ToolAgentHandler=" + toolAgentHandle + ", "
                	+ "WorkItemID=" + wid + ")";
                throw new InvalidToolAgentException(errMsg);
            }
            AppExecutionBean bean = (AppExecutionBean)beans.get(0);
        
            // gUNVJn
            conn.setAutoCommit(false);
        
            // AvP[V~
            process.destroy();

            // AvP[V̎sԂ1FُIɍXV
            appExecutionDao.updateState(bean.getAppName(), 
                    bean.getToolAgent(), 
                    bean.getExecId(), 
                    bean.getAppState(),
                    ApplicationState.TERMINATED,
                    new Timestamp(System.currentTimeMillis()));
            
            // R~bg
            conn.commit();
            
            // ƍڂ̊ʒm
            WorkflowServiceManager manager = WorkflowEngine.getInstance();
            session = connect();
            WorkItemHandler handler = manager.getWorkItemHandler(session);
            handler.changeWorkItemState(session, wid, WorkItemState.CLOSED_TERMINATED);
            
        } catch (Exception ex) {
            try {
                // [obN
                conn.rollback();
            } catch (Exception ex2) {
                /* Ignore */
            }
            // O
            String errMsg = StringManager.get("E2002")
            	+ "(ToolAgentHandler=" + toolAgentHandle + ", "
            	+ "WorkItemID=" + wid + ")";
            log.error(errMsg, ex);
            throw new InvalidToolAgentException(errMsg);
        } finally {
            try {
                if (conn != null && (! conn.isClosed())) {
                    conn.close();
                }
                if (session != null) {
                    disconnect(session);
                }
            } catch (Exception ex) {
                /* Ignore */
            }
        }
        
        // O
        log.info(StringManager.get("I2004"));
    }
    
    /**
     * AvP[VNc[G[WFg̃NX擾B
     * 
     * @return	AvP[VNc[G[WFg̃NX
     */
    protected String getToolAgentClassName() {
        return this.getClass().getName();
    }
    
    /**
     * AvP[Vs𑗐ML[擾B
     * 
     * c[G[WFgɃL[KvŁÃL[ɖOȂĂ͂ȂȂB
     * ̃L[̓c[G[WFgŗL̕łB
     * {Iɂ̓c[G[WFggpB
     * ec[G[WFgŏdȂ悤ɒӂ邱ƁB
     *
     * @return	L[
     */
    protected String getQueueName() {
        return SystemCommandToolAgentFactory.QUEUE_NAME;
    }
    
    /**
     * L[ɑMAvP[Vs擾B
     *
     * AvP[VsNXł́ȀɂāA
     * AvP[VsB 
     *
     * @param appName	`Ɏw肵AvP[V
     * @param wid		ƍID
     * @param handler	c[G[WFgnh
     * @param attrList	ꗗ
     * @return	AvP[Vs
     */
    protected AppExecutionInfo getExecInfo(String appName, String wid,
            int handler, Attribute[] attrList) 
    {
        return new SystemCommandExecutionInfo(appName, getToolAgentClassName(), 
                wid, handler, attrList);
    }
    
    /**
     * AvP[V`Ă邩ǂ`FbNB
     * 
     * AvP[V`ĂȂꍇAOB
     *
     * @param appName	AvP[V
     * @throws	ApplicationNotDefinedException	AvP[V`ĂȂꍇ
     * @see jp.co.argo21.nautica.workflow.ta.AbstractToolAgent#checkApplicationDefined(java.lang.String)
     */
    protected void checkApplicationDefined(String appName)
    	throws ApplicationNotDefinedException {
        
        SystemCommandConfig config = null;
        try {
	        config = SystemCommandConfigFactory.getConfig();
        } catch (Exception ex) {
            // G[
            String errMsg = StringManager.get("E2004")
            	+ "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg, ex);
        }
        
        if (config == null || !config.existApplication(appName)) {
            // G[
            String errMsg = StringManager.get("E2004")
        		+ "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg);
        }
    }
}
