/* $Id: SystemCommandToolAgentFactory.java,v 1.11 2005/08/26 04:53:00 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgent;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgentFactory;

/**
 * VXeR}hpc[G[WFĝ߂̃t@Ng[NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.11 $
 * @since   Nautica Workflow 0.9
 */
public class SystemCommandToolAgentFactory implements ToolAgentFactory {

    /** VXeR}hpc[G[WFg̃L[ */
    protected static final String QUEUE_NAME = "SYSTEM_COMMAND";
    
    /* OIuWFNg */
    private static Logger log = Logger.getLogger(SystemCommandToolAgentFactory.class);

    /** c[G[WFgs */
    private int retryCount = 1;

    /* VXeR}hpc[G[WFg̃VOgCX^X */
    private static AbstractToolAgent agent = null;
    
    static {
        init();
    }
    
    /**
     * c[G[WFgt@NgIuWFNg𐶐B
     *
     */
    public SystemCommandToolAgentFactory() {
        // ȂB
    }
    
	/**
	 * VXeR}hpc[G[WFgԂB
	 *
	 * @return c[G[WFg
	 * @see jp.co.argo21.nautica.workflow.wfmc.ToolAgentFactory#getToolAgent()
	 */
	public ToolAgent getToolAgent() {
	    if (agent != null) {
	        agent.setRetryCount(this.retryCount);
	    }
	    
	    return agent;
	}

	/**
	 * s񐔂ݒ肷B
	 *
	 * @param count s
	 * @see jp.co.argo21.nautica.workflow.wfmc.ToolAgentFactory#setRetryCount(int)
	 */
	public void setRetryCount(int count) {
		int n = count;
		if (n < 1) n = 1;
		this.retryCount = n;
	}
	
	/**
	 * t@NgNXB
	 * 
	 * VXeR}hsp̃L[Ď
	 * }l[WʃXbhŋNB
	 */
	private synchronized static void init() {
	    
	    WorkflowEngine engine = null;
	    String session = null;
	    try {
		    // ݒ擾
		    SystemCommandConfig config = SystemCommandConfigFactory.getConfig();
		    
		    engine = WorkflowEngine.getInstance();
		    session = engine.connect(config.getUser(), config.getPassword());
		    /* bZ[WL[쐬 */
		    SystemCommandMessageAdapter executor = new SystemCommandMessageAdapter();
		    engine.generateQueue(session, QUEUE_NAME, executor);
		    
		    if (agent == null) {
		        agent = new SystemCommandToolAgent(config.getUser(), config.getPassword());
		    }
	    } catch (Exception ex) {
	        // G[
	        String errMsg = StringManager.get("E2006");
	        log.error(errMsg, ex);
	    } finally {
	        try {
	            if (session != null) {
	                engine.disconnect(session);
	            }
	        } catch (Exception ex) {
	            /* Ignore */
	        }
	    }
	}
}
