/* $Id: ToolAgentHandleCreator.java,v 1.5 2005/08/26 04:52:47 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;

/**
 * c[G[WFgnhisIDj𐶐WFl[^łB
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class ToolAgentHandleCreator {

    /** c[G[WFgnh̃V[PXL[ */
    private static final String SEQKEY = "TOOLAGENT";
    
    /**
     * ftHgRXgN^
     */
    private ToolAgentHandleCreator() {
        super();
    }
    
    /**
     * c[G[WFgnh𐶐B
     *
     * @return	c[G[WFgnh
     * @throws	WorkflowException c[G[WFgnh擾ɃG[ꍇ
     */
    public static int generate() throws WorkflowException
    {
        int handler = 0;
        
		try {
			handler = UniqueKeyGenerator.generateForInt(SEQKEY);
		} catch (Exception ex) {
			throw new WorkflowException(StringManager.get("E2007"), ex);
		}
        return handler;
    }
    
}
