/* $Id: DurationHelper.java,v 1.6 2005/08/26 04:53:03 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.util;

import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;

/**
 * Ԋ֘Ãwp[NXB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class DurationHelper
{
	/** N */
	static public final long YEAR_VAL   =        1000L;
	/**  */
	static public final long MONTH_VAL  =       60000L;
	/**  */
	static public final long DAY_VAL    =      360000L;
	/**  */
	static public final long HOUR_VAL   =    86400000L;
	/**  */
	static public final long MINUTE_VAL =  2592000000L;
	/** b */
	static public final long SECOND_VAL = 31536000000L;
	
	/**
	 * ԒPʂƐlo߃~bԂB
	 *
	 * @param unit ԒP
	 * @param value l
	 * @return o߃~b
	 */
	static public long calculateDuration(int unit, int value)
	{
		long valueUnit = DAY_VAL;
		
		switch (unit) {
		case ProcessDefinition.SECOND:
			valueUnit = SECOND_VAL;
			break;
		case ProcessDefinition.MINUTE:
			valueUnit = MINUTE_VAL;
			break;
		case ProcessDefinition.HOUR:
			valueUnit = HOUR_VAL;
			break;
		case ProcessDefinition.MONTH:
			valueUnit = MONTH_VAL;
			break;
		case ProcessDefinition.YEAR:
			valueUnit = YEAR_VAL;
			break;
		}
		return (valueUnit * value);
	}
}
