/* $Id: FilterHelper.java,v 1.8 2005/08/26 04:53:00 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.util;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;

/**
 * tB^[Ɋւwp[NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class FilterHelper
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/**
	 * tB^[w肵āAƍڏԂoB
	 * ɂ́AԃtB^[ԃtB^[߂O[vtB^[
	 * w肷邱ƁB
	 *
	 * @param filter ԃtB^[ԃtB^[߂O[vtB^[
	 * @return ƍڏ
	 * @throws InvalidFilterException gpłȂtB^[w肳Ăꍇ
	 */
	static public WorkItemState[] getWorkItemState(Filter filter)
	throws InvalidFilterException
	{
		List list = new ArrayList();
		
		parseWorkItemState(list, filter);
		
		return (WorkItemState[])list.toArray(new WorkItemState[list.size()]);
	}
	
	/**
	 * tB^[K؂ȏԂoB
	 *
	 * @param list ƍڏ
	 * @param filter ԃtB^[ԃtB^[߂O[vtB^[
	 * @throws InvalidFilterException gpłȂtB^[w肳Ăꍇ
	 */
	static private void parseWorkItemState(List list, Filter filter)
	throws InvalidFilterException
	{
		if (filter == null) {
			//NOP
		} else if (filter instanceof StateFilter) {
			parseWorkItemState(list, (StateFilter)filter);
		} else if (filter instanceof GroupFilter) {
			parseWorkItemState(list, (GroupFilter)filter);
		} else {
			// ƍڂɂ͎gpłȂtB^[w肳Ă܂B
			String errMsg = StringManager.get("E0037");
			eLog.error(errMsg);
			throw new InvalidFilterException(errMsg);
		}
	}
	
	/**
	 * tB^[K؂ȏԂoB
	 *
	 * @param list ƍڏ
	 * @param filter ԃtB^[
	 * @throws InvalidFilterException gpłȂtB^[w肳Ăꍇ
	 */
	static private void parseWorkItemState(List list, StateFilter filter)
	throws InvalidFilterException
	{
		WfState state = filter.getState();
		if (state instanceof WorkItemState) {
			list.add(state);
		} else {
			// ƍڏԂɂ͎gpłȂtB^[w肳Ă܂B
			String errMsg = StringManager.get("E0038");
			eLog.error(errMsg);
			throw new InvalidFilterException(errMsg);
		}
	}
	
	/**
	 * tB^[K؂ȏԂoB
	 *
	 * @param list ƍڏ
	 * @param filter ԃtB^[߂O[vtB^[
	 * @throws InvalidFilterException gpłȂtB^[w肳Ăꍇ
	 */
	static private void parseWorkItemState(List list, GroupFilter filter)
	throws InvalidFilterException
	{
		Filter[] children = filter.getChild();
		
		for (int i = 0; i < children.length; i++) {
			parseWorkItemState(list, children[i]);
		}
	}
}
