/* $Id: IDGenerator.java,v 1.1 2005/08/26 06:19:26 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
* 
* This file is part of Nautica Workflow Core.
* 
*  Nautica Workflow Core is free software; you can redistribute it and/or modify
*  it under the terms of the GNU Lesser General Public License as published by
*  the Free Software Foundation; either version 2.1 of the License, or
*  (at your option) any later version.
* 
*  Nautica Workflow Core is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Lesser General Public License for more details.
* 
*  You should have received a copy of the GNU Lesser General Public License
*  along with Nautica Workflow Core Core; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*  
*/
package jp.co.argo21.nautica.workflow.util;

import java.text.DecimalFormat;

import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * 18ȏō\ID𐶐WFl[^
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 0.9
 */
public class IDGenerator
{
	static private DecimalFormat longFormatter
		= new DecimalFormat("0000000000000");

	static private DecimalFormat shortFormatter
		= new DecimalFormat("00000");

	static private long ms = System.currentTimeMillis();

	static private short num = 0;
	
	/**
	 * ID𐶐B쒆Ɏv߂ꂽƂlA
	 * ݎێȌꍇ̓JE^̍XVɂƂǂ߂B
	 * 
	 * @return ID
	 */
	static public synchronized String generate()
	{
		long t = System.currentTimeMillis();
		if (ms >= t) {
			num++;
		} else {
			ms = t;
			num = 0;
		}

		String s1 = longFormatter.format(ms);
		String s2 = shortFormatter.format(num);
		return (s1 + s2);
	}
	
	/**
	 * prefixŎn܂ID𐶐B
	 * 
	 * @param prefix Ou
	 * @return ID
	 */
	static public String generate(String prefix)
	{
		String s;
		if (StringUtils.checkNull(prefix)) s = "";
		else s = prefix;

		return (s + generate());
	}
	
	/**
	 * sɎw肳ꂽID󕶎̎A܂͊IDprefixŎn܂ĂȂƂ
	 * VIDB
	 * ȊÓAID̂܂ܕԂB
	 * 
	 * @param prefix Ou
	 * @param s ID
	 * @return ID
	 */
	static public String generate(String prefix, String s)
	{
		if (StringUtils.checkNull(s)) return generate(prefix);
		else if (StringUtils.checkNull(prefix)) return s;
		else if (s.startsWith(prefix)) return s;
		else return generate(prefix);
	}
}
