/* $Id: ParticipantHelper.java,v 1.6 2005/08/26 04:53:02 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.util;

import jp.co.argo21.nautica.workflow.engine.ParticipantImpl;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

/**
 * [Nt[Q҂Ɋւwp[NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class ParticipantHelper
{
	/**
	 * [U[Nt[QҌ^ɕϊB
	 *
	 * @param user [U
	 * @return [Nt[Q
	 * @throws WorkflowException ϊɎsꍇ
	 */
	static public Participant narrow(User user)
	throws WorkflowException
	{
		if (user instanceof Participant) return (Participant)user;
		
		return new ParticipantImpl(user.getID(), user.getName(), Participant.HUMAN);
	}

	/**
	 * gD[Nt[QҌ^ɕϊB
	 *
	 * @param org [U
	 * @return [Nt[Q
	 * @throws WorkflowException ϊɎsꍇ
	 */
	static public Participant narrow(Organization org)
	throws WorkflowException
	{
		if (org instanceof Participant) return (Participant)org;
		
		return new ParticipantImpl(org.getID(), org.getName(), Participant.ORGANIZATIONAL_UNIT);
	}

	/**
	 * [[Nt[QҌ^ɕϊB
	 *
	 * @param role [
	 * @return [Nt[Q
	 * @throws WorkflowException ϊɎsꍇ
	 */
	static public Participant narrow(Role role)
	throws WorkflowException
	{
		if (role instanceof Participant) return (Participant)role;
		
		return new ParticipantImpl(role.getID(), role.getName(), Participant.ROLE);
	}
}
