/* $Id: StateHelper.java,v 1.6 2005/08/26 04:53:01 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.util;

import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;

/**
 * ԂɊւwp[NXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class StateHelper
{
	/**
	 * vZXԂANeBreBԂɕϊB
	 *
	 * @param state vZX
	 * @return ANeBreB
	 */
	static public ActivityState convert(ProcessState state)
	{
		int stateNum = state.toInt();
		return ActivityState.getState(stateNum);
	}

	/**
	 * ANeBreBԂƍڏԂɕϊB
	 *
	 * @param state ANeBreB
	 * @return ƍڏ
	 */
	static public WorkItemState convert(ActivityState state)
	{
		int stateNum = state.toInt();
		return WorkItemState.getState(stateNum);
	}

	/**
	 * ƍڏԂANeBreBԂɕϊB
	 *
	 * @param state ƍڏ
	 * @return ANeBreB
	 */
	static public ActivityState convert(WorkItemState state)
	{
		int stateNum = state.toInt();
		return ActivityState.getState(stateNum);
	}
	
	/**
	 * srcԂdestԂɑJډ\ԂB
	 *
	 * @param src Jڌ
	 * @param dest Jڐ
	 * @return Jډ\Ȃtrue
	 */
	static public boolean containsTransitable(ProcessState src, ProcessState dest)
	{
		int destStateNum = dest.toInt();
		WorkItemState[] tstates = WorkItemState.getTransitableStates(src.toInt());
		
		for (int i = 0; i < tstates.length; i++) {
			int stateNum = tstates[i].toInt();
			if (stateNum == destStateNum) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * srcԂdestԂɑJډ\ԂB
	 *
	 * @param src Jڌ
	 * @param dest Jڐ
	 * @return Jډ\Ȃtrue
	 */
	static public boolean containsTransitable(ActivityState src, ActivityState dest)
	{
		int destStateNum = dest.toInt();
		WorkItemState[] tstates = WorkItemState.getTransitableStates(src.toInt());
		
		for (int i = 0; i < tstates.length; i++) {
			int stateNum = tstates[i].toInt();
			if (stateNum == destStateNum) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * srcԂdestԂɑJډ\ԂB
	 *
	 * @param src Jڌ
	 * @param dest Jڐ
	 * @return Jډ\Ȃtrue
	 */
	static public boolean containsTransitable(WorkItemState src, WorkItemState dest)
	{
		int destStateNum = dest.toInt();
		WorkItemState[] tstates = WorkItemState.getTransitableStates(src.toInt());
		
		for (int i = 0; i < tstates.length; i++) {
			int stateNum = tstates[i].toInt();
			if (stateNum == destStateNum) {
				return true;
			}
		}
		return false;
	}
}
