/* $Id: UniqueKeyGenerator.java,v 1.9 2005/08/26 04:53:02 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;

import javax.sql.DataSource;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.SequencerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * j[NL[𐶐WFl[^łB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class UniqueKeyGenerator
{
	/** GWO */
	static private Logger eLog = LogManager.getEngineLogger();
	
	/** \itH[}bg */
	static private DecimalFormat longFormatter
		= new DecimalFormat("0000000000000");


	/**
	 * prefixŎn܂ID𐶐B
	 * 
	 * @param prefix Ou
	 * @return ID
	 */
	static synchronized public String generate(String prefix)
	throws WorkflowException
	{
		Connection conn = null;
		try {
			boolean exec = true;
			String s = null;
			while (exec) {
				try {
					DataSource ds = DataAccessManager.getDataSource();
					conn = ds.getConnection();
					conn.setAutoCommit(false);

					WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
					SequencerDAO sequencer = daoFactory.getSequencerDAO(conn);
					long seq = sequencer.next(prefix);
					s = longFormatter.format(seq);
					exec = false;
					conn.commit();
				} catch (SQLException ex) {
					try {
						conn.rollback();
					} catch (Exception ex2) { /* NOP */ }

					int code = ex.getErrorCode();
					if (code == 1205) {
						/* retry */
					} else {
						throw ex;
					}
				} finally {
					try {
						if (conn != null && conn.isClosed() == false) {
							conn.close();
						}
					} catch (Exception ex2) { /* NOP */ }
				}
			}

			return prefix + s;
		} catch (Exception ex) {
			// j[NL[ɃG[N܂B
			String errMsg = StringManager.get("E0039");
			eLog.error(errMsg, ex);
			throw new WorkflowException(errMsg, ex);
		}
	}

	/**
	 * lID𐶐B
	 * 
	 * @param prefix Ou
	 * @return ID
	 */
	static synchronized public int generateForInt(String prefix)
	throws WorkflowException
	{
		Connection conn = null;
		try {
			boolean exec = true;
			String s = null;
			int seq = 0;
			while (exec) {
				try {
					DataSource ds = DataAccessManager.getDataSource();
					conn = ds.getConnection();
					conn.setAutoCommit(false);

					WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
					SequencerDAO sequencer = daoFactory.getSequencerDAO(conn);
					seq = sequencer.nextForInt(prefix);
					exec = false;
					conn.commit();
				} catch (SQLException ex) {
					try {
						conn.rollback();
					} catch (Exception ex2) { /* NOP */ }

					int code = ex.getErrorCode();
					if (code == 1205) {
						/* retry */
					} else {
						throw ex;
					}
				} finally {
					try {
						if (conn != null && conn.isClosed() == false) {
							conn.close();
						}
					} catch (Exception ex2) { /* NOP */ }
				}
			}
			return seq;
		} catch (Exception ex) {
			// j[NL[ɃG[N܂B
			String errMsg = StringManager.get("E0039");
			eLog.error(errMsg, ex);
			throw new WorkflowException(errMsg, ex);
		}
	}
}
