/* $Id: ActivityState.java,v 1.7 2005/08/26 04:52:39 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import java.util.ArrayList;
import java.util.List;

import jp.co.argo21.nautica.workflow.omg.WfState;

/**
 * ANeBreBCX^X̏Ԃ\IuWFNgłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public final class ActivityState implements WfState
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** open.not_running.not_started */
	static public final ActivityState OPEN_NOT_RUNNING_NOT_STARTED
		= new ActivityState("open.not_running.not_started", 1);

	/** open.not_running.not_started */
	static public final ActivityState OPEN_NOT_RUNNING_SUSPENDED
		= new ActivityState("open.not_running.suspended", 2);

	/** open.running */
	static public final ActivityState OPEN_RUNNING
		= new ActivityState("open.running", 3);

	/** closed.completed */
	static public final ActivityState CLOSED_COMPLETED
		= new ActivityState("closed.completed", 4);

	/** closed.terminated */
	static public final ActivityState CLOSED_TERMINATED
		= new ActivityState("closed.terminated", 5);

	/** closed.aborted */
	static public final ActivityState CLOSED_ABORTED
		= new ActivityState("closed.aborted", 6);
	
	/** ԕ */
	private String stateString;
	
	/** Ԓl */
	private int stateNum;
	
	/**
	 * ̏ԔԍɊYANeBreBԂԂB
	 * 
	 * @param n@Ԕԍ
	 * @return@ANeBreB
	 */
	static public ActivityState getState(int n)
	{
		switch (n) {
		case 1: return OPEN_NOT_RUNNING_NOT_STARTED;
		case 2: return OPEN_NOT_RUNNING_SUSPENDED;
		case 3: return OPEN_RUNNING;
		case 4: return CLOSED_COMPLETED;
		case 5: return CLOSED_TERMINATED;
		case 6: return CLOSED_ABORTED;
		default: return null;
		}
	}
	
	/**
	 * ̏ԔԍɊYJډ\ȃANeBreBԂԂB
	 * 
	 * @param n@Ԕԍ
	 * @return@Jډ\ȃANeBreB
	 */
	static public ActivityState[] getTransitableStates(int n)
	{
		List states = new ArrayList();
		switch (n) {
		case 1:
		case 2:
			states.add(OPEN_RUNNING);
			states.add(CLOSED_COMPLETED);
			states.add(CLOSED_TERMINATED);
			states.add(CLOSED_ABORTED);
			break;
		case 3:
			states.add(OPEN_NOT_RUNNING_SUSPENDED);
			states.add(CLOSED_COMPLETED);
			states.add(CLOSED_TERMINATED);
			states.add(CLOSED_ABORTED);
			break;
		}
		return (ActivityState[])states.toArray(new ActivityState[0]);
	}
	
	/**
	 * ANeBreBCX^X̏Ԃ𐶐B
	 * 
	 * @param s ԕ
	 * @param i Ԓl
	 */
	private ActivityState(String s, int i)
	{
		stateString = s;
		stateNum = i;
	}

	/**
	 * Ԃ̕\ԂB
	 * 
	 * @return Ԃ̕\
	 */
	public String toString()
	{
		return stateString;
	}

	/**
	 * Ԃ̐l\ԂB
	 * 
	 * @return Ԃ̐l\
	 */
	public int toInt()
	{
		return stateNum;
	}
	
	/**
	 * Ɏw肳ꂽIuWFNgƂ̔rs
	 *
	 * @param obj rΏۃIuWFNg
	 * @return r
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj)
	{
		if (obj == null || obj instanceof ActivityState == false) {
			return false;
		}
		
		ActivityState s = (ActivityState)obj;
		return (this.stateNum == s.stateNum && this.stateString.equals(s.stateString));
	}

	/**
	 * ӂ̃nbVR[hԂB
	 *
	 * @return nbVR[h
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode()
	{
		return stateString.hashCode();
	}
}
