/* $Id: DefinitionRepository.java,v 1.5 2005/08/26 04:52:21 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * DefinitionRepositorýAXPDLt@CƖ̂̃}bsOǗĂA
 * vɉāAXPDLIuWFNgĕԂB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public interface DefinitionRepository
{
	/**
	 * w肳ꂽ`̓o^sAGWɔFB
	 *
	 * @param session ZbVID
	 * @param name [Nt[`
	 * @param path [Nt[`̑΃pX
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws WorkflowException vZXCX^XIDLłȂꍇ
	 */
	public void registerDefinition(String session, String name, String path)
	throws InvalidSessionException, WorkflowException;

	/**
	 * Ƀ}b`vZX`ꗗԂB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return ꂽvZX`Tv̔z
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public ProcDef[] getProcessDefinitions(
			String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException;

	/**
	 * vZX`IDœ肳ꂽ`݂̌̏ԂJډ\
	 * vZX`ԈꗗԂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @return vZX`Ԃ̔z
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 */
	public ProcessDefinitionState[] getProcessDefinitionStates(
			String session,String pdid)
	throws InvalidSessionException, InvalidProcessDefinitionException;

	/**
	 * vZX`ԂύXB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param state vZX`
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	public void changeProcessDefinitionState (String session,
			String pdid, ProcessDefinitionState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidStateException, TransitionNotAllowedException;
}
