/* $Id: Participant.java,v 1.8 2005/08/26 04:52:40 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.omg.WfObject;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * [Nt[Q҂\B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public interface Participant extends WfObject
{
	/** l */
	static public final int HUMAN               = ParticipantDefinition.HUMAN;
	/** gDP */
	static public final int ORGANIZATIONAL_UNIT = ParticipantDefinition.ORGANIZATIONAL_UNIT;
	/** [ */
	static public final int ROLE                = ParticipantDefinition.ROLE;
	/** VXe */
	static public final int SYSTEM              = ParticipantDefinition.SYSTEM;

	/**
	 * QIDԂB
	 *
	 * @return ID
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getID() throws WorkflowException;

	/**
	 * QҖ̂Ԃ
	 *
	 * @return 
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getName() throws WorkflowException;

	/**
	 * QҌ^ԂB
	 * 
	 * @return	QҌ^
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public int getType() throws WorkflowException;

	/**
	 * ێ鑮ԂB
	 *
	 * @param name 
	 * @return l
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String getAttribute(String name)
	throws WorkflowException;

	/**
	 * ݒ肷B
	 *
	 * @param name 
	 * @param value l
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public void setAttribute(String name, String value)
	throws WorkflowException;

	/**
	 * ێ邷ׂĂ̑ԂB
	 *
	 * @return ̈ꗗ
	 * @throws WorkflowException@[Nt[֘AŗOꍇ
	 */
	public String[] getAllAttributeNames()
	throws WorkflowException;
}
