/* $Id: ProcessDefinitionState.java,v 1.10 2005/08/26 04:52:29 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import java.util.ArrayList;
import java.util.List;

import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * vZX`̏Ԃ\IuWFNgłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
public final class ProcessDefinitionState implements WfState
{
	/** VAo[WUID */
	static private final long serialVersionUID = 20050000000000001L;

	/** enable */
	static public final ProcessDefinitionState ENABLE
		= new ProcessDefinitionState("enable", 1001);

	/** disable */
	static public final ProcessDefinitionState DISABLE
		= new ProcessDefinitionState("disable", 1002);
	
	/** ԕ */
	private String stateString;
	
	/** Ԓl */
	private int stateNum;

	/**
	 * ̏ԔԍɊYvZX`ԂԂB
	 * 
	 * @param n@Ԕԍ
	 * @return@vZX`
	 */
	static public ProcessDefinitionState getState(int n)
	{
		switch (n) {
		case 1001: return ENABLE;
		case 1002: return DISABLE;
		default: return null;
		}
	}
	
	/**
	 * ̏ԔԍɊYJډ\ȃvZX`ԂԂB
	 * 
	 * @param n@Ԕԍ
	 * @return@Jډ\ȃvZX`
	 */
	static public ProcessDefinitionState[] getTransitableStates(int n)
	{
		List states = new ArrayList();
		switch (n) {
		case 1001:
			states.add(DISABLE);
			break;
		case 1002:
			states.add(ENABLE);
			break;
		}
		return (ProcessDefinitionState[])states.toArray(new ProcessDefinitionState[0]);
	}
	
	/**
	 * Jڂ̃`FbNsB
	 *
	 * @param src \[X
	 * @param dest@^[Qbg
	 * @throws TransitionNotAllowedException@JڂȂꍇɓO
	 */
	static public void checkTransition(ProcessDefinitionState src,
		ProcessDefinitionState dest)
	throws TransitionNotAllowedException
	{
		if (src.equals(ProcessDefinitionState.ENABLE)) {
			if (dest.equals(ProcessDefinitionState.DISABLE) == false) {
			    String errMsg = StringManager.get("E0050")
				    + "(SourceState=" + src + ", DestinationState=" + dest + ")";
				throw new TransitionNotAllowedException(errMsg);
			}
		} else if (src.equals(ProcessDefinitionState.DISABLE)) {
			if (dest.equals(ProcessDefinitionState.ENABLE) == false) {
			    String errMsg = StringManager.get("E0050")
			        + "(SourceState=" + src + ", DestinationState=" + dest + ")";
				throw new TransitionNotAllowedException(errMsg);
			}
		} else {
		    String errMsg = StringManager.get("E0050")
		        + "(SourceState=" + src + ", DestinationState=" + dest + ")";
			throw new TransitionNotAllowedException(errMsg);
		}
	}
	
	
	/**
	 * vZX`̏Ԃ𐶐B
	 * 
	 * @param s ԕ
	 * @param i Ԓl
	 */
	private ProcessDefinitionState(String s, int i)
	{
		stateString = s;
		stateNum = i;
	}
	
	/**
	 * Ԃ̕\ԂB
	 * 
	 * @return Ԃ̕\
	 */
	public String toString()
	{
		return stateString;
	}

	/**
	 * Ԃ̐l\ԂB
	 * 
	 * @return Ԃ̐l\
	 */
	public int toInt()
	{
		return stateNum;
	}
	
	/**
	 * Ɏw肳ꂽIuWFNgƂ̔rs
	 *
	 * @param obj rΏۃIuWFNg
	 * @return r
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj)
	{
		if (obj == null || obj instanceof ProcessDefinitionState == false) {
			return false;
		}
		
		ProcessDefinitionState s = (ProcessDefinitionState)obj;
		return (this.stateNum == s.stateNum && this.stateString.equals(s.stateString));
	}

	/**
	 * ӂ̃nbVR[hԂB
	 *
	 * @return nbVR[h
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode()
	{
		return stateString.hashCode();
	}
}
