/* $Id: ToolAgent.java,v 1.3 2005/08/26 04:52:26 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;


/**
 * ToolAgent́A[Nt[AvP[V̎sǗG[WFg
 * C^tF[XłB́AWfMC̃C^tF[X3Ɏ
 * c[G[WFg̊TOɊYBʂ̃c[G[WFg̎@
 * ł͋K肵ȂAWfMC̎dĺAɎsv̂߂
 * ҂ŝ悤Ȃ̂z肵ĂB
 * {[Nt[VXe^pՂŕW񋟂c[G[WFǧʎ́A
 * ̍lKpB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public interface ToolAgent {

	/**
	 * AvP[V̋NsB
	 * <b></b>ƂāA{[Nt[VXe^pՂł́A
	 * Ƀ[h͊܂܂Ȃ̂ƂB
	 * 
	 * @param appName `Ɏw肵AvP[V
	 * @param wid ƍID
	 * @param attrList ꗗ
	 * @return c[G[WFgnh
	 * @throws ApplicationNotStartedException AvP[VJnłȂꍇ
	 * @throws ApplicationNotDefinedException AvP[V`ĂȂꍇ
	 * @throws ApplicationBusyException AvP[VrW[ŗv󂯂Ȃꍇ
	 */
	public int invokeApplication(String appName,
			String wid, Attribute[] attrList)
	throws ApplicationNotStartedException,
		ApplicationNotDefinedException, ApplicationBusyException;
	
	/**
	 * AvP[V̎sԂ擾B
	 * sԂ́Aȉ̂̂pӂB
	 * <ul>
	 * <li>0FI</li>
	 * <li>1FُI</li>
	 * <li>2FJn</li>
	 * <li>3F~</li>
	 * <li>6Fs</li>
	 * <li>9Fʕs</li>
	 * </ul>
	 * <b></b>ƂāA{[Nt[VXe^pՂł́A
	 * ɂẮAc[G[WFgA܂̓AvP[V
	 * XVƑz肵Aɂ͊܂܂ȂƂƂB
	 * 
	 * @param toolAgentHandle c[G[WFgnh
	 * @param wid ƍID
	 * @return s
	 * @throws ApplicationBusyException AvP[VrW[ŗv󂯂Ȃꍇ
	 * @throws InvalidToolAgentException LłȂc[G[WFgnhw肵ꍇ
	 * @throws InvalidWorkItemException LłȂƍIDw肵ꍇ
	 */
	public int requestAppStatus(int toolAgentHandle, String wid)
	throws ApplicationBusyException, InvalidToolAgentException,
		InvalidWorkItemException;

	/**
	 * AvP[V̒~sB
	 *
	 * @param toolAgentHandle c[G[WFgnh
	 * @param wid ƍID
	 * @throws ApplicationNotStoppedException AvP[V~łȂꍇ
	 * @throws InvalidToolAgentException LłȂc[G[WFgnhw肵ꍇ
	 * @throws InvalidWorkItemException LłȂƍIDw肵ꍇ
	 * @throws ApplicationBusyException AvP[VrW[ŗv󂯂Ȃꍇ
	 */
	public void terminateApplication(int toolAgentHandle, String wid)
	throws ApplicationNotStoppedException, InvalidToolAgentException,
		InvalidWorkItemException, ApplicationBusyException;
}
