/* $Id: WorkItemHandler.java,v 1.5 2005/08/26 04:52:10 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;


/**
 * ƍڃnh́A[Nt[ɑ΂NCAgC^tF[XłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public interface WorkItemHandler {

	/**
	 * ƍڈꗗ̎擾sB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return ƍڈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public WorkItem[] getWorkItems(String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException;

	/**
	 * ƍڂ̎擾sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @return ƍ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 */
	public WorkItem getWorkItem(String session, String wid)
	throws InvalidSessionException, InvalidWorkItemException;

	/**
	 * ƍڂ̊sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 */
	public void completeWorkItem(String session, String wid)
	throws InvalidSessionException, InvalidWorkItemException;

	/**
	 * ݂̍ƍڂJډ\ȏԂ̈ꗗԂB
	 * ԂȂꍇ́A̔zԂB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param filter ptB^[
	 * @return ƍڏԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public WorkItemState[] getWorkItemStates(String session,
			String wid, Filter filter)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidFilterException;
	
	/**
	 * ƍڏԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param state ƍڏ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	public void changeWorkItemState(String session,
			String wid, WorkItemState state)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidStateException, TransitionNotAllowedException;
	
	/**
	 * ƍڂ̍Ċ蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param sourceUser 蓖đÕ[U
	 * @param targetUser 蓖Č̃[U
	 * @param wid ƍID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidSourceUserException 蓖đO[ULłȂꍇ
	 * @throws InvalidTargetUserException 蓖Đ惆[ULłȂꍇ
	 */
	public void reassignWorkItem(String session,
			Participant sourceUser, Participant targetUser, String wid)
	throws InvalidSessionException, InvalidWorkItemException,
	InvalidSourceUserException, InvalidTargetUserException;
	
	/**
	 * ƍڑꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param filter ptB^[
	 * @return ƍڑꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public Attribute[] getWorkItemAttributes(String session,
			String wid, Filter filter)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidFilterException;
	
	/**
	 * ƍڑ̎擾sB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	public Attribute getWorkItemAttributeValue(String session,
			String wid, String name)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidAttributeException;

	/**
	 * ƍڑ̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param wid ƍID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidWorkItemException ƍIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 */
	public void assignWorkItemAttribute(String session,
			String wid, Attribute attr)
	throws InvalidSessionException, InvalidWorkItemException,
		InvalidAttributeException, AttributeAssignmentFailedException;
}
