/* $Id: WorkflowAdminHandler.java,v 1.3 2005/08/26 04:52:32 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

/**
 * [Nt[Ǘnh́A[Nt[ɑ΂
 * ǗNCAgC^tF[XłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public interface WorkflowAdminHandler {

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @param state VvZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	public void changeProcessesState(String session,
			String pdid, Filter filter, ProcessState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
	InvalidFilterException, InvalidStateException,
	TransitionNotAllowedException;

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁AԂ̕ύXsB
	 * w\ȃtB^[StateFilterƂB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filter ptB^[
	 * @param state VANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	public void changeActivitiesState(String session,
			String pdid, String adid, Filter filter, ActivityState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
	InvalidActivityNameException, InvalidFilterException,
	InvalidStateException, TransitionNotAllowedException;

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁A~sB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public void terminateProcesses(String session,
			String pdid, Filter filter)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException;

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁Å蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	public void assignProcessesAttribute(String session,
			String pdid, Filter filter, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, InvalidAttributeException;

	/**
	 * w肳ꂽvZX`ƃANeBreB`ɑ
	 * ANeBreBCX^XtB^[ōi荞݁A
	 * ̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param adid ANeBreB`ID
	 * @param filter ptB^[
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidActivityNameException w肳ꂽANeBreB`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	public void assignActivitiesAttribute(String session,
			String pdid, String adid, Filter filter, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidActivityNameException, InvalidFilterException,
		InvalidAttributeException;

	/**
	 * w肳ꂽvZX`ɑvZXCX^X
	 * tB^[ōi荞݁AfsB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param filter ptB^[
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public void abortProcesses(String session,
			String pdid, Filter filter)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException;

	/**
	 * w肳ꂽvZXCX^X̒fsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 */
	public void abortProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException;
}
