/* $Id: WorkflowEngineHandler.java,v 1.5 2005/08/26 04:52:10 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

/**
 * [Nt[GWnh́A[Nt[GWɑ΂
 * NCAgC^tF[XłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public interface WorkflowEngineHandler {

	/**
	 * vZXCX^X̐sB
	 *
	 * @param session ZbVID
	 * @param pdid vZX`ID
	 * @param name vZXCX^X
	 * @return vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessDefinitionException w肳ꂽvZX`IDLłȂꍇ
	 */
	public String createProcess(String session, String pdid, String name)
	throws InvalidSessionException, InvalidProcessDefinitionException;

	/**
	 * vZXCX^X̊JnsB
	 * JnꍇɁAvZXCX^XIDXV悤
	 * \łB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @return XVꂽvZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	public String startProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidAttributeException;

	/**
	 * vZXCX^X̒~sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 */
	public void terminateProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException;

	/**
	 * w肳ꂽvZXCX^Xp\ȏԈꗗ̎擾sB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return vZXCX^XԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public ProcessState[] getProcessStates(String session, 
			String pid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidFilterException;


	/**
	 * vZXCX^XԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param state vZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	public void changeProcessState(String session,
			String pid, ProcessState state)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidStateException, TransitionNotAllowedException;

	/**
	 * vZXCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return ꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public Attribute[] getProcessAttributes(String session,
			String pid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidFilterException;

	/**
	 * vZXCX^X̑l̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	public Attribute getProcessAttributeValue(String session,
			String pid, String name)
	throws InvalidSessionException, InvalidAttributeException;

	/**
	 * vZXCX^X̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 */
	public void assignProcessAttribute(String session,
			String pid, Attribute attr)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidAttributeException, AttributeAssignmentFailedException;

	/**
	 * w肳ꂽANeBreBCX^Xp\ȏԈꗗ̎擾sB
	 * p\ȃtB^[StateFilter݂̂ƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^XԈꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public ActivityState[] getActivityStates(String session,
			String pid, String aid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidFilterException;

	/**
	 * ANeBreBCX^XԂ̕ύXsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param state ANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidStateException w肳ꂽԂLłȂꍇ
	 * @throws TransitionNotAllowedException Ԃ̕ύXĂȂꍇ
	 */
	public void changeActivityState(String session,
			String pid, String aid, ActivityState state)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidStateException,
		TransitionNotAllowedException;

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, AttributeFilter, GroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public Attribute[] getActivityAttributes(String session,
			String pid, String aid, Filter filter)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidFilterException;

	/**
	 * ANeBreBCX^X̑l̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param name 
	 * @return 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 */
	public Attribute getActivityAttributeValue(String session,
			String pid, String aid, String name)
	throws InvalidSessionException, InvalidAttributeException;

	/**
	 * ANeBreBCX^X̊蓖ĂsB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @param attr 
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 * @throws InvalidAttributeException LłȂꍇ
	 * @throws AttributeAssignmentFailedException ̊蓖ĂɎsꍇ
	 */
	public void assignActivityAttribute(String session,
			String pid, String aid, Attribute attr)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException, InvalidAttributeException,
		AttributeAssignmentFailedException;

	/**
	 * vZXCX^Xꗗ̎擾sB
	 * p\ȃtB^[NameFilter, StateFilterAGroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return vZẌꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public Process[] getProcesses(String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException;

	/**
	 * vZXCX^X̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @return vZXCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 */
	public Process getProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException;

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter, StateFilterAGroupFilterƂB
	 *
	 * @param session ZbVID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public Activity[] getActivities(String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException;

	/**
	 * ANeBreBCX^Xꗗ̎擾sB
	 * p\ȃtB^[AttributeFilter, StateFilterAGroupFilterƂB
	 * WfMCdlłpid͂ȂA͌ł낤ƔfA
	 * pidɒǉB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param filter ptB^[
	 * @return ANeBreBCX^Xꗗ
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidFilterException w肳ꂽtB^[LłȂꍇ
	 */
	public Activity[] getActivities(String session, String pid, Filter filter)
	throws InvalidSessionException, InvalidFilterException;

	/**
	 * ANeBreBCX^X̎擾sB
	 *
	 * @param session ZbVID
	 * @param pid vZXCX^XID
	 * @param aid ANeBreBCX^XID
	 * @return ANeBreBCX^X
	 * @throws InvalidSessionException w肳ꂽZbV̏ꍇ
	 * @throws InvalidProcessInstanceException vZXCX^XIDLłȂꍇ
	 * @throws InvalidActivityInstanceException ANeBreBCX^XIDLłȂꍇ
	 */
	public Activity getActivity(String session, String pid, String aid)
	throws InvalidSessionException, InvalidProcessInstanceException,
		InvalidActivityInstanceException;
}
