/* $Id: ActivityInspectorManager.java,v 1.3 2005/08/26 04:50:12 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.inspector.AutomaticActivityInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.BasicActivityInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.ConcurrentActivityInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.InteractiveActivityInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.SubprocessActivityInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.TransitionalActivityInspector;

/**
 * ANeBreB̃vpeB{ҏWCXyN^ǗB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityInspectorManager extends InspectorManager
{
	/**
	 * ANeBreBCXyN^Ǘ𐶐B
	 */
	public ActivityInspectorManager()
	{
		putInspectorForName(ActivityElement.START, new TransitionalActivityInspector());
		putInspectorForName(ActivityElement.INTERACTIVE, new InteractiveActivityInspector());
		putInspectorForName(ActivityElement.AUTOMATIC, new AutomaticActivityInspector());
		putInspectorForName(ActivityElement.SUBPROCESS, new SubprocessActivityInspector());
		putInspectorForName(ActivityElement.CONCUR_START, new ConcurrentActivityInspector());
		putInspectorForName(ActivityElement.CONCUR_END, new ConcurrentActivityInspector());
		putInspectorForName(ActivityElement.END, new BasicActivityInspector());
	}
}
