/* $Id: ActivityInspectorView.java,v 1.3 2005/08/26 04:50:09 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.inspector.Inspector;

/**
 * ANeBreBCXyN^𐧌䂷r[
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityInspectorView extends JPanel
{
	/** CXyN^}l[W */
	private InspectorManager manager = new ActivityInspectorManager();

	/** XN[yC */
	private JScrollPane scroll;
	/** ݒ{^ */
	private JButton setButton;

	/** CXyN^ */
	private Inspector inspector;

	/**
	 * r[𐶐B
	 */
	public ActivityInspectorView()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		scroll = new JScrollPane();
		scroll.setPreferredSize(new Dimension(500, 500));
		scroll.setMinimumSize(new Dimension(500, 500));
		scroll.setViewportView((JComponent)inspector);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		setButton = new JButton(rm.getResource("JButton.label.set"));
		setButton.addActionListener(new SetInfoAction());
		buttonPane.add(setButton);

		setLayout(new BorderLayout());
		add(scroll, BorderLayout.CENTER);
		add(buttonPane, BorderLayout.SOUTH);

		inspect(null);
	}

	/**
	 * vfɑΉCXyN^\B
	 * 
	 * @param elem	vf
	 */
	public void inspect(ActivityElement elem)
	{
		if (inspector != null) {
			//Ƀ[hĂCXyN^unloadĂяoB
			inspector.unload();
		}

		if (elem == null) {
			inspector = manager.getDefaultInspector();
		} else {
			String inspectorName = elem.getType();
			inspector = manager.getInspectorForName(inspectorName);
		}
		//VKɃ[hꂽCXyN^initĂяoB
		inspector.init();
		inspector.setInspectable(elem);
		setButton.setEnabled(! inspector.isAutoCommit());
		scroll.setViewportView((JComponent)inspector);
		repaint();
	}

	/**
	 * ݒ菈
	 */
	class SetInfoAction implements ActionListener
	{
		/**
		 * ݒ{^ꂽƂCXyN^ɒʒmB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (inspector != null) {
				if (inspector.check()) {
					inspector.commit();
				}
			}
			DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
			ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
			if (frame == null) return;
			frame.getView().repaint();
		}
	}
}
