/* $Id: ActivityStateFactory.java,v 1.3 2005/08/26 04:50:21 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.AutomaticActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.ConcurrentEndActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.ConcurrentStartActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.EndActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.InteractiveActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.StartActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.SubprocessActivityState;

/**
 * ANeBreBp̃t@Ng
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityStateFactory
{
	/** t@Ng */
	static ActivityStateFactory singleton = new ActivityStateFactory();

	/**
	 * t@Ng̃CX^XԂB
	 * 
	 * @return	t@Ng
	 */
	static public ActivityStateFactory getInstance()
	{
		return singleton;
	}
	
	/**
	 * t@Ng𐶐B
	 */
	private ActivityStateFactory()
	{
	}
	
	/**
	 * w肳ꂽނ̃ANeBreB𐶐AԂB
	 * 
	 * @param activityKind	ANeBreB
	 * @return	ANeBreB
	 */
	public ActivityState createElement(String activityKind)
	{
		if (activityKind == null) return null;

		if (activityKind.equals(ActivityElement.START)) {
			return new StartActivityState();
		} else if (activityKind.equals(ActivityElement.INTERACTIVE)) {
			return new InteractiveActivityState();
		} else if (activityKind.equals(ActivityElement.AUTOMATIC)) {
			return new AutomaticActivityState();
		} else if (activityKind.equals(ActivityElement.SUBPROCESS)) {
			return new SubprocessActivityState();
		} else if (activityKind.equals(ActivityElement.CONCUR_START)) {
			return new ConcurrentStartActivityState();
		} else if (activityKind.equals(ActivityElement.CONCUR_END)) {
			return new ConcurrentEndActivityState();
		} else if (activityKind.equals(ActivityElement.END)) {
			return new EndActivityState();
		} else {
			return null;
		}
	}

	/**
	 * pbgANeBreBԂԂB
	 * 
	 * @param paletteName	pbg
	 * @return	ANeBreB
	 */
	public ActivityState createElementByPalette(String paletteName)
	{
		if (paletteName == null) return null;

		if (paletteName.equals(WorkflowDesignerConstants.PAL_INTERACTIVE)) {
			return new InteractiveActivityState();
		} else if (paletteName.equals(WorkflowDesignerConstants.PAL_AUTOMATIC)) {
			return new AutomaticActivityState();
		} else if (paletteName.equals(WorkflowDesignerConstants.PAL_SUBPROCESS)) {
			return new SubprocessActivityState();
		} else if (paletteName.equals(WorkflowDesignerConstants.PAL_END)) {
			return new EndActivityState();
		} else {
			return null;
		}
	}
}
