/* $Id: ConcurrentLayer.java,v 1.3 2005/08/26 04:50:04 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;

/**
 * sANeBreBō\铯KwǗB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ConcurrentLayer
{
	//KẘJnANeBreB
	private ActivityElement start;
	//Kw̏IANeBreB
	private ActivityElement end;
	//e̓Kw̃Xg
	private ConcurrentLayer parentLayer;
	//铯Kw̃Xg
	private List subLayers = new ArrayList();
	//̃C[ɏANeBreB̃Xg
	private List activities = new ArrayList();

	/**
	 * Kw𐶐B
	 * 
	 * @param p	eKw
	 * @param s	sJnANeBreB
	 * @param e	sIANeBreB
	 */
	public ConcurrentLayer(ConcurrentLayer p, ActivityElement s, ActivityElement e)
	{
		this.parentLayer = p;
		this.start = s;
		this.end = e;
	}

	/**
	 * Kw𐶐B
	 */
	public ConcurrentLayer()
	{
	}

	/**
	 * KwIDԂB
	 * 
	 * @return	KwID
	 */
	public String getLayerID()
	{
		return start.getBlockID();
	}

	/**
	 * KwɃANeBreBǉB
	 * 
	 * @param elem	ANeBreB
	 */	
	public void addLayerElement(ActivityElement elem)
	{
		if (elem == null) return;
		elem.setAffiliateBID(getStartElement().getBlockID());
		activities.add(elem);		
	}

	/**
	 * KwANeBreB폜B
	 * 
	 * @param elem	ANeBreB
	 */	
	public void removeLayerElement(ActivityElement elem)
	{
		if (elem == null) return;
		if (activities.contains(elem)) {
			activities.remove(elem);
		} else {
			Iterator it = subLayers.iterator();
			while (it.hasNext()) {
				ConcurrentLayer layer = (ConcurrentLayer)it.next();
				layer.removeLayerElement(elem);
			}
		}
		elem.setAffiliateBID(null);
		elem.setParentBID(null);
	}

	/**
	 * KwǉB
	 * 
	 * @param layer	Kw
	 */	
	public void addLayer(ConcurrentLayer layer)
	{
		if (layer == null) return;
		
		layer.getStartElement().setParentBID(getStartElement().getBlockID());
		layer.getEndElement().setParentBID(getStartElement().getBlockID());
		addLayerElement(layer.getStartElement());
		addLayerElement(layer.getEndElement());
		subLayers.add(layer);
	}

	/**
	 * Kw폜B
	 * 
	 * @param l	Kw
	 */	
	public void removeLayer(ConcurrentLayer l)
	{
		if (l == null) return;

		if (subLayers.contains(l)) {
			removeLayerElement(l.getStartElement());
			removeLayerElement(l.getEndElement());
			l.clearParentLayer();
			subLayers.remove(l);
		} else {
			Iterator it = subLayers.iterator();
			while (it.hasNext()) {
				ConcurrentLayer layer = (ConcurrentLayer)it.next();
				layer.removeLayer(l);
			}
		}
	}

	/**
	 * Ow̃ANeBreBWĕԂB
	 * 
	 * @param list	WpXg
	 */	
	public void collectAllLayerElement(List list)
	{
		Iterator lit = subLayers.iterator();
		while (lit.hasNext()) {
			ConcurrentLayer layer = (ConcurrentLayer)lit.next();
			layer.collectAllLayerElement(list);
		}

		Iterator ait = activities.iterator();
		while (ait.hasNext()) {
			ActivityElement act = (ActivityElement)ait.next();
			if (list.contains(act) == false) list.add(act);
		}
		if (list.contains(start) == false) list.add(start);
		if (list.contains(end) == false) list.add(end);
	}

	/**
	 * 󂯓\ȓKwԂB
	 * 
	 * @param lx _XW
	 * @param ly _YW
	 * @return Kw
	 */
	public ConcurrentLayer getReceivableLayer(int lx, int ly)
	{
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			ConcurrentLayer layer = ((ConcurrentLayer)it.next()).getReceivableLayer(lx, ly);
			if (layer != null) return layer;
		}

		int slx = start.getLogicalX();
		int sly = start.getLogicalY();
		int elx = end.getLogicalX();
		int ely = end.getLogicalY();
		
		if (lx >= slx && lx <= elx && ly >= sly && ly <= ely) return this;
		else return null;
	}

	/**
	 * w肳ꂽANeBreB铯KwԂB
	 * 
	 * @param elem	ANeBreB
	 * @return	Kw
	 */	
	public ConcurrentLayer getContainLayer(ActivityElement elem)
	{
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			ConcurrentLayer layer = ((ConcurrentLayer)it.next()).getContainLayer(elem);
			if (layer != null) return layer;
		}

		if (elem == getStartElement()) return this;
		else if (elem == getEndElement()) return this;
		else if (activities.contains(elem)) return this;
		else return null;
	}

	/**
	 * ̊Kw̕sJnANeBreBԂB
	 * 
	 * @return	sJnANeBreB
	 */
	public ActivityElement getStartElement()
	{
		return start;
	}

	/**
	 * ̊Kw̕sIANeBreBԂB
	 * 
	 * @return	sIANeBreB
	 */
	public ActivityElement getEndElement()
	{
		return end;
	}
	/**
	 * e̓KwԂB
	 * 
	 * @return	Kw
	 */
	public ConcurrentLayer getParentLayer()
	{
		return parentLayer;
	}
	
	/**
	 * e̓Kw폜B
	 */
	public void clearParentLayer()
	{
		parentLayer = null;
	}

	/**
	 * Ĕzu\ȏ㕔ʒuԂB
	 * 
	 * @return	_W
	 */
	public Point getMinimumUpperPoint()
	{
		int x = Integer.MAX_VALUE;
		int y = Integer.MAX_VALUE;
		
		Iterator it = activities.iterator();
		while (it.hasNext()) {
			ActivityElement act = (ActivityElement)it.next();
			if (x > act.getLogicalX()) x = act.getLogicalX();
			if (y > act.getLogicalY()) y = act.getLogicalY();
		}
		return new Point(x, y);
	}

	/**
	 * Ĕzu\ȉʒuԂB
	 * 
	 * @return	_W
	 */	
	public Point getMinimumLowerPoint()
	{
		int x = 0;
		int y = 0;
		
		Iterator it = activities.iterator();
		while (it.hasNext()) {
			ActivityElement act = (ActivityElement)it.next();
			if (x < act.getLogicalX()) x = act.getLogicalX();
			if (y < act.getLogicalY()) y = act.getLogicalY();
		}
		if (x == -1) x = start.getLogicalX();
		if (y == -1) y = start.getLogicalY();
		return new Point(x, y);
	}

	/**
	 * Kw̔wi`悷B
	 * 
	 * @param g	`ΏۃOtBbNX
	 * @param c	`F
	 * @param grid	Pʕ
	 */
	public void paintLayerBackgroud(Graphics g, Color c, int grid)
	{
		int x = start.getLogicalX() * grid;
		int y = start.getLogicalY() * grid;
		int w = end.getLogicalX() * grid + grid - x;
		int h = end.getLogicalY() * grid + grid - y;
		
		g.setColor(c);
		g.fillRect(x, y, w, h);
		
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			((ConcurrentLayer)it.next()).paintLayerBackgroud(g, c, grid);
		}
	}

	/**
	 * Kw̘g`悷B
	 * 
	 * @param g	`ΏۃOtBbNX
	 * @param c	`F
	 * @param grid	Pʕ
	 */
	public void paintLayerBorder(Graphics g, Color c, int grid)
	{
		int x = start.getLogicalX() * grid;
		int y = start.getLogicalY() * grid;
		int w = end.getLogicalX() * grid + grid - x;
		int h = end.getLogicalY() * grid + grid - y;

		g.setColor(c);
		g.drawRect(x, y, w, h);
		g.drawRect(x + 1, y + 1, w - 2, h - 2);
		
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			((ConcurrentLayer)it.next()).paintLayerBorder(g, c, grid);
		}
	}

	/**
	 * ̊Kw̕sIANeBreBݒ肷B
	 * 
	 * @param element	sIANeBreB
	 */
	public void setEndElement(ActivityElement element) {
		end = element;
	}

	/**
	 * e̓Kwݒ肷B
	 * 
	 * @param layer	Kw
	 */
	public void setParentLayer(ConcurrentLayer layer) {
		parentLayer = layer;
	}

	/**
	 * ̊Kw̕sJnANeBreBݒ肷B
	 * 
	 * @param element	sJnANeBreB
	 */
	public void setStartElement(ActivityElement element) {
		start = element;
	}
}
