/* $Id: ConcurrentLayerManager.java,v 1.3 2005/08/26 04:50:20 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;

/**
 * KwǗ}l[W
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ConcurrentLayerManager
{
	//铯Kw̃Xg
	private List subLayers = new ArrayList();
	//̃C[ɏANeBreB̃Xg
	private List activities = new ArrayList();

	/**
	 * Kw}l[W𐶐B
	 */
	public ConcurrentLayerManager()
	{
	}

	/**
	 * KwB
	 * 
	 * @param activities	ANeBreBꗗ
	 */
	public void initConcurrentLayer(List activities)
	{
		Map layers = new Hashtable();

		Iterator it = activities.iterator();
		while (it.hasNext()) {
			ActivityElement act = (ActivityElement)it.next();
			if (act.getType().equals(ActivityElement.CONCUR_START)) {
				ConcurrentLayer l = new ConcurrentLayer();
				l.setStartElement(act);
				layers.put(act.getBlockID(), l);
			}
		}

		Iterator it2 = activities.iterator();
		while (it2.hasNext()) {
			ActivityElement act = (ActivityElement)it2.next();
			if (act.getType().equals(ActivityElement.CONCUR_START)) {
			} else if (act.getType().equals(ActivityElement.CONCUR_END)) {
				ConcurrentLayer l = (ConcurrentLayer)layers.get(act.getBlockID());
				l.setEndElement(act);
				String parentID = act.getParentBID();
				if (StringUtils.checkNull(parentID)) {
					addLayer(l);
				} else {
					ConcurrentLayer pl = (ConcurrentLayer)layers.get(parentID);
					l.setParentLayer(pl);
					pl.addLayer(l);
				}
			} else {
				String affID = act.getAffiliateBID();
				if (StringUtils.checkNull(affID)) {
				} else {
					ConcurrentLayer al = (ConcurrentLayer)layers.get(affID);
					al.addLayerElement(act);
				}
			}
		}
	}

	/**
	 * KwIDԂB
	 * 
	 * @return	KwID
	 */
	public String getLayerID()
	{
		return null;
	}
	
	/**
	 * KwɃANeBreBǉB
	 * 
	 * @param elem	ANeBreB
	 */
	public void addLayerElement(ActivityElement elem)
	{
		if (elem == null) return;
		activities.add(elem);
	}

	/**
	 * KwANeBreB폜B
	 * 
	 * @param elem	ANeBreB
	 */	
	public void removeLayerElement(ActivityElement elem)
	{
		if (elem == null) return;
		if (activities.contains(elem)) {
			activities.remove(elem);
		} else {
			Iterator it = subLayers.iterator();
			while (it.hasNext()) {
				ConcurrentLayer layer = (ConcurrentLayer)it.next();
				layer.removeLayerElement(elem);
			}
		}
	}

	/**
	 * 
	 * 
	 * @param layer
	 */	
	public void addLayer(ConcurrentLayer layer)
	{
		if (layer == null) return;
		
		addLayerElement(layer.getStartElement());
		addLayerElement(layer.getEndElement());
		subLayers.add(layer);
	}

	/**
	 * KwǉB
	 * 
	 * @param l	Kw
	 */	
	public void removeLayer(ConcurrentLayer l)
	{
		if (l == null) return;
		if (subLayers.contains(l)) {
			removeLayerElement(l.getStartElement());
			removeLayerElement(l.getEndElement());
			l.clearParentLayer();
			subLayers.remove(l);
		} else {
			Iterator it = subLayers.iterator();
			while (it.hasNext()) {
				ConcurrentLayer layer = (ConcurrentLayer)it.next();
				layer.removeLayer(l);
			}
		}
	}

	/**
	 * KwWB
	 * 
	 * @param list	Kwi[ꗗ
	 */	
	public void collectAllLayerElement(List list)
	{
		Iterator lit = subLayers.iterator();
		while (lit.hasNext()) {
			ConcurrentLayer layer = (ConcurrentLayer)lit.next();
			layer.collectAllLayerElement(list);
		}

		Iterator ait = activities.iterator();
		while (ait.hasNext()) {
			ActivityElement act = (ActivityElement)ait.next();
			if (list.contains(act) == false) list.add(act);
		}
	}
	
	/**
	 * 󂯓\ȓC[ԂB
	 * 
	 * @param lx _XW
	 * @param ly _YW
	 * @return Kw
	 */
	public ConcurrentLayer getReceivableLayer(int lx, int ly)
	{
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			ConcurrentLayer layer = ((ConcurrentLayer)it.next()).getReceivableLayer(lx, ly);
			if (layer != null) return layer;
		}
		return null;
	}

	/**
	 * w肳ꂽANeBreB铯KwԂB
	 * 
	 * @param elem	ANeBreB
	 * @return	Kw
	 */	
	public ConcurrentLayer getContainLayer(ActivityElement elem)
	{
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			ConcurrentLayer layer = ((ConcurrentLayer)it.next()).getContainLayer(elem);
			if (layer != null) return layer;
		}
		return null;
	}

	/**
	 * ̊Kw̕sJnANeBreBԂB
	 * 
	 * @return	sJnANeBreB
	 */
	public ActivityElement getStartElement()
	{
		return null;
	}

	/**
	 * ̊Kw̕sIANeBreBԂB
	 * 
	 * @return	sIANeBreB
	 */
	public ActivityElement getEndElement()
	{
		return null;
	}

	/**
	 * e̓KwԂB
	 * 
	 * @return	Kw
	 */
	public ConcurrentLayer getParentLayer()
	{
		return null;
	}

	/**
	 * Ĕzu\ȏ㕔ʒuԂB
	 * 
	 * @return	_W
	 */	
	public Point getMinimumUpperPoint()
	{
		int x = Integer.MAX_VALUE;
		int y = Integer.MAX_VALUE;
		return new Point(x, y);
	}

	/**
	 * Ĕzu\ȉʒuԂB
	 * 
	 * @return	_W
	 */	
	public Point getMinimumLowerPoint()
	{
		int x = 0;
		int y = 0;
		return new Point(x, y);
	}

	/**
	 * Kw̔wi`悷B
	 * 
	 * @param g	`ΏۃOtBbNX
	 * @param c	`F
	 * @param grid	Pʕ
	 */	
	public void paintLayerBackgroud(Graphics g, Color c, int grid)
	{
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			((ConcurrentLayer)it.next()).paintLayerBackgroud(g, c, grid);
		}
	}

	/**
	 * Kw̘g`悷B
	 * 
	 * @param g	`ΏۃOtBbNX
	 * @param c	`F
	 * @param grid	Pʕ
	 */
	public void paintLayerBorder(Graphics g, Color c, int grid)
	{
		Iterator it = subLayers.iterator();
		while (it.hasNext()) {
			((ConcurrentLayer)it.next()).paintLayerBorder(g, c, grid);
		}
	}
}
